/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class MockFileSystem
extends FileSystem {
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final String name;

    public MockFileSystem(String string) {
        this.name = string;
    }

    @Override
    public FileSystemProvider provider() {
        throw new UnsupportedOperationException("provider() N/A");
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            return;
        }
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    public Iterable getRootDirectories() {
        return Collections.emptyList();
    }

    public Iterable getFileStores() {
        return Collections.emptyList();
    }

    public Set supportedFileAttributeViews() {
        return Collections.emptySet();
    }

    @Override
    public Path getPath(String string, String ... stringArray) {
        throw new UnsupportedOperationException("getPath(" + string + ") " + Arrays.toString(stringArray));
    }

    @Override
    public PathMatcher getPathMatcher(String string) {
        throw new UnsupportedOperationException("getPathMatcher(" + string + ")");
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("getUserPrincipalLookupService() N/A");
    }

    @Override
    public WatchService newWatchService() {
        throw new IOException("newWatchService() N/A");
    }

    public String toString() {
        return this.name;
    }
}

