/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.util;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.file.util.BaseFileSystem;
import org.apache.sshd.common.file.util.BasePath$1;
import org.apache.sshd.common.util.GenericUtils;

public abstract class BasePath
implements Path {
    protected final String root;
    protected final List names;
    private final BaseFileSystem fileSystem;
    private String strValue;
    private int hashValue;

    protected BasePath(BaseFileSystem baseFileSystem, String string, List list) {
        this.fileSystem = Objects.requireNonNull(baseFileSystem, "No file system provided");
        this.root = string;
        this.names = list;
    }

    protected BasePath asT() {
        return this;
    }

    protected BasePath create(String string, String ... stringArray) {
        return this.create(string, GenericUtils.unmodifiableList(stringArray));
    }

    protected BasePath create(String string, Collection collection) {
        return this.create(string, GenericUtils.unmodifiableList(collection));
    }

    protected BasePath create(String string, List list) {
        return (BasePath)this.fileSystem.create(string, list);
    }

    @Override
    public BaseFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.root != null;
    }

    @Override
    public BasePath getRoot() {
        if (this.isAbsolute()) {
            return this.create(this.root, new String[0]);
        }
        return null;
    }

    @Override
    public BasePath getFileName() {
        if (!this.names.isEmpty()) {
            return this.create(null, (String)this.names.get(this.names.size() - 1));
        }
        return null;
    }

    @Override
    public BasePath getParent() {
        if (this.names.isEmpty() || this.names.size() == 1 && this.root == null) {
            return null;
        }
        return this.create(this.root, this.names.subList(0, this.names.size() - 1));
    }

    @Override
    public int getNameCount() {
        return this.names.size();
    }

    @Override
    public BasePath getName(int n2) {
        int n3 = this.getNameCount();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("Invalid name index " + n2 + " - not in range [0-" + n3 + "]");
        }
        return this.create(null, this.names.subList(n2, n2 + 1));
    }

    @Override
    public BasePath subpath(int n2, int n3) {
        int n4 = this.getNameCount();
        if (n2 < 0 || n2 >= n4 || n3 > n4 || n2 >= n3) {
            throw new IllegalArgumentException("subpath(" + n2 + "," + n3 + ") bad index range - allowed [0-" + n4 + "]");
        }
        return this.create(null, this.names.subList(n2, n3));
    }

    protected boolean startsWith(List list, List list2) {
        return list.size() >= list2.size() && list.subList(0, list2.size()).equals(list2);
    }

    @Override
    public boolean startsWith(Path path) {
        BasePath basePath = this.asT();
        BasePath basePath2 = this.checkPath(path);
        return Objects.equals(basePath.getFileSystem(), basePath2.getFileSystem()) && Objects.equals(basePath.root, basePath2.root) && this.startsWith(basePath.names, basePath2.names);
    }

    @Override
    public boolean startsWith(String string) {
        return this.startsWith(this.getFileSystem().getPath(string, new String[0]));
    }

    protected boolean endsWith(List list, List list2) {
        return list2.size() <= list.size() && list.subList(list.size() - list2.size(), list.size()).equals(list2);
    }

    @Override
    public boolean endsWith(Path path) {
        BasePath basePath = this.asT();
        BasePath basePath2 = this.checkPath(path);
        if (basePath2.isAbsolute()) {
            return basePath.compareTo(basePath2) == 0;
        }
        return this.endsWith(basePath.names, basePath2.names);
    }

    @Override
    public boolean endsWith(String string) {
        return this.endsWith(this.getFileSystem().getPath(string, new String[0]));
    }

    protected boolean isNormal() {
        int n2 = this.getNameCount();
        if (n2 == 0 || n2 == 1 && !this.isAbsolute()) {
            return true;
        }
        boolean bl2 = this.isAbsolute();
        boolean bl3 = true;
        for (String string : this.names) {
            if (string.equals("..")) {
                if (!bl2) continue;
                bl3 = false;
                break;
            }
            if (string.equals(".")) {
                bl3 = false;
                break;
            }
            bl2 = true;
        }
        return bl3;
    }

    @Override
    public BasePath normalize() {
        if (this.isNormal()) {
            return this.asT();
        }
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        for (String string : this.names) {
            if (string.equals("..")) {
                String string2 = (String)arrayDeque.peekLast();
                if (string2 != null && !string2.equals("..")) {
                    arrayDeque.removeLast();
                    continue;
                }
                if (this.isAbsolute()) continue;
                arrayDeque.add(string);
                continue;
            }
            if (string.equals(".")) continue;
            arrayDeque.add(string);
        }
        return arrayDeque.equals(this.names) ? this.asT() : this.create(this.root, arrayDeque);
    }

    @Override
    public BasePath resolve(Path path) {
        BasePath basePath = this.asT();
        BasePath basePath2 = this.checkPath(path);
        if (basePath2.isAbsolute()) {
            return basePath2;
        }
        if (basePath2.names.isEmpty()) {
            return basePath;
        }
        String[] stringArray = new String[basePath.names.size() + basePath2.names.size()];
        int n2 = 0;
        for (String string : basePath.names) {
            stringArray[n2++] = string;
        }
        for (String string : basePath2.names) {
            stringArray[n2++] = string;
        }
        return this.create(basePath.root, stringArray);
    }

    @Override
    public BasePath resolve(String string) {
        return this.resolve(this.getFileSystem().getPath(string, GenericUtils.EMPTY_STRING_ARRAY));
    }

    @Override
    public Path resolveSibling(Path path) {
        Objects.requireNonNull(path, "Missing sibling path argument");
        BasePath basePath = this.getParent();
        return basePath == null ? path : basePath.resolve(path);
    }

    @Override
    public Path resolveSibling(String string) {
        return this.resolveSibling(this.getFileSystem().getPath(string, GenericUtils.EMPTY_STRING_ARRAY));
    }

    @Override
    public BasePath relativize(Path path) {
        int n2;
        BasePath basePath = this.asT();
        BasePath basePath2 = this.checkPath(path);
        if (!Objects.equals(basePath.getRoot(), basePath2.getRoot())) {
            throw new IllegalArgumentException("Paths have different roots: " + this + ", " + path);
        }
        if (basePath2.equals(basePath)) {
            return this.create(null, new String[0]);
        }
        if (basePath.root == null && basePath.names.isEmpty()) {
            return basePath2;
        }
        int n3 = 0;
        for (n2 = 0; n2 < Math.min(basePath.names.size(), basePath2.names.size()) && ((String)basePath.names.get(n2)).equals(basePath2.names.get(n2)); ++n2) {
            ++n3;
        }
        n2 = Math.max(0, basePath.names.size() - n3);
        List list = basePath2.names.size() <= n3 ? Collections.emptyList() : basePath2.names.subList(n3, basePath2.names.size());
        ArrayList<String> arrayList = new ArrayList<String>(n2 + list.size());
        arrayList.addAll(Collections.nCopies(n2, ".."));
        arrayList.addAll(list);
        return this.create(null, arrayList);
    }

    @Override
    public BasePath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this.asT();
        }
        return ((BasePath)this.fileSystem.getDefaultDir()).resolve(this);
    }

    @Override
    public URI toUri() {
        File file = this.toFile();
        return file.toURI();
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("To file " + this.toAbsolutePath() + " N/A");
    }

    public WatchKey register(WatchService watchService, WatchEvent.Kind ... kindArray) {
        return this.register(watchService, kindArray, (WatchEvent.Modifier[])null);
    }

    public WatchKey register(WatchService watchService, WatchEvent.Kind[] kindArray, WatchEvent.Modifier ... modifierArray) {
        throw new UnsupportedOperationException("Register to watch " + this.toAbsolutePath() + " N/A");
    }

    @Override
    public Iterator iterator() {
        return new BasePath$1(this).iterator();
    }

    @Override
    public int compareTo(Path path) {
        BasePath basePath = this.asT();
        BasePath basePath2 = this.checkPath(path);
        int n2 = this.compare(basePath.root, basePath2.root);
        if (n2 != 0) {
            return n2;
        }
        for (int i2 = 0; i2 < Math.min(basePath.names.size(), basePath2.names.size()); ++i2) {
            String string;
            String string2 = (String)basePath.names.get(i2);
            n2 = this.compare(string2, string = (String)basePath2.names.get(i2));
            if (n2 == 0) continue;
            return n2;
        }
        return basePath.names.size() - basePath2.names.size();
    }

    protected int compare(String string, String string2) {
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        return string2 == null ? 1 : string.compareTo(string2);
    }

    protected BasePath checkPath(Path path) {
        Objects.requireNonNull(path, "Missing path argument");
        if (path.getClass() != this.getClass()) {
            throw new ProviderMismatchException("Path is not of this class: " + path + "[" + path.getClass().getSimpleName() + "]");
        }
        BasePath basePath = (BasePath)path;
        BaseFileSystem baseFileSystem = basePath.getFileSystem();
        if (((FileSystem)baseFileSystem).provider() != this.fileSystem.provider()) {
            throw new ProviderMismatchException("Mismatched providers for " + basePath);
        }
        return basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        BasePath basePath = this;
        synchronized (basePath) {
            if (this.hashValue == 0) {
                this.hashValue = this.calculatedHashCode();
                if (this.hashValue == 0) {
                    this.hashValue = 1;
                }
            }
        }
        return this.hashValue;
    }

    protected int calculatedHashCode() {
        return Objects.hash(this.getFileSystem(), this.root, this.names);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Path && this.compareTo((Path)object) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        BasePath basePath = this;
        synchronized (basePath) {
            if (this.strValue == null) {
                this.strValue = this.asString();
            }
        }
        return this.strValue;
    }

    protected String asString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.root != null) {
            stringBuilder.append(this.root);
        }
        String string = this.getFileSystem().getSeparator();
        for (String string2 : this.names) {
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

