/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.util;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFileSystem
extends FileSystem {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FileSystemProvider fileSystemProvider;

    protected BaseFileSystem(FileSystemProvider fileSystemProvider) {
        this.fileSystemProvider = Objects.requireNonNull(fileSystemProvider, "No file system provider");
    }

    public Path getDefaultDir() {
        return this.getPath("/", new String[0]);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public FileSystemProvider provider() {
        return this.fileSystemProvider;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    public Iterable getRootDirectories() {
        return Collections.singleton(this.create("/", new String[0]));
    }

    public Iterable getFileStores() {
        throw new UnsupportedOperationException("No file stores available");
    }

    @Override
    public Path getPath(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!GenericUtils.isEmpty(string)) {
            this.appendDedupSep(stringBuilder, this.handleWindowsSeparator(string));
        }
        if (GenericUtils.length(stringArray) > 0) {
            for (String object2 : stringArray) {
                if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
                    stringBuilder.append('/');
                }
                this.appendDedupSep(stringBuilder, this.handleWindowsSeparator(object2));
            }
        }
        if (stringBuilder.length() > 1 && stringBuilder.charAt(stringBuilder.length() - 1) == '/') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        Object object3 = stringBuilder.toString();
        String string2 = null;
        if (((String)object3).startsWith("/")) {
            string2 = "/";
            object3 = ((String)object3).substring(1);
        }
        String[] stringArray2 = GenericUtils.split((String)object3, '/');
        Path path = this.create(string2, stringArray2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPath({}, {}): {}", new Object[]{string, Arrays.toString(stringArray), path});
        }
        return path;
    }

    protected void appendDedupSep(StringBuilder stringBuilder, CharSequence charSequence) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == '/' && stringBuilder.length() != 0 && stringBuilder.charAt(stringBuilder.length() - 1) == '/') continue;
            stringBuilder.append(c2);
        }
    }

    protected String handleWindowsSeparator(String string) {
        if (this.hostFsHasWindowsSeparator()) {
            return string.replace('\\', '/');
        }
        return string;
    }

    protected boolean hostFsHasWindowsSeparator() {
        return OsUtils.isWin32();
    }

    @Override
    public PathMatcher getPathMatcher(String string) {
        String string2;
        int n2 = Objects.requireNonNull(string, "No argument").indexOf(58);
        if (n2 <= 0 || n2 == string.length() - 1) {
            throw new IllegalArgumentException("syntaxAndPattern must have form \"syntax:pattern\" but was \"" + string + "\"");
        }
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        switch (string3) {
            case "glob": {
                string2 = this.globToRegex(string4);
                break;
            }
            case "regex": {
                string2 = string4;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported path matcher syntax: '" + string3 + "'");
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPathMatcher({}): {}", (Object)string, (Object)string2);
        }
        Object object = Pattern.compile(string2);
        return arg_0 -> BaseFileSystem.lambda$getPathMatcher$0((Pattern)object, arg_0);
    }

    protected String globToRegex(String string) {
        StringBuilder stringBuilder = new StringBuilder(Objects.requireNonNull(string, "No pattern").length());
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        char[] cArray = string.toCharArray();
        block16: for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            switch (c2) {
                case '\\': {
                    if (++i2 >= cArray.length) {
                        stringBuilder.append('\\');
                        continue block16;
                    }
                    char c3 = cArray[i2];
                    switch (c3) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            stringBuilder.append("\\\\");
                            break;
                        }
                        default: {
                            stringBuilder.append('\\');
                        }
                    }
                    stringBuilder.append(c3);
                    continue block16;
                }
                case '*': {
                    stringBuilder.append(n3 == 0 ? ".*" : "*");
                    continue block16;
                }
                case '?': {
                    stringBuilder.append(n3 == 0 ? (char)'.' : '?');
                    continue block16;
                }
                case '[': {
                    ++n3;
                    n4 = i2 + 1;
                    stringBuilder.append('[');
                    continue block16;
                }
                case ']': {
                    --n3;
                    stringBuilder.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (n3 == 0 || n4 == i2 && c2 == '^') {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c2);
                    continue block16;
                }
                case '!': {
                    stringBuilder.append(n4 == i2 ? (char)'^' : '!');
                    continue block16;
                }
                case '{': {
                    ++n2;
                    stringBuilder.append('(');
                    continue block16;
                }
                case '}': {
                    --n2;
                    stringBuilder.append(')');
                    continue block16;
                }
                case ',': {
                    stringBuilder.append(n2 > 0 ? (char)'|' : ',');
                    continue block16;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        String string2 = stringBuilder.toString();
        if (this.log.isTraceEnabled()) {
            this.log.trace("globToRegex({}): {}", (Object)string, (Object)string2);
        }
        return string2;
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException("Watch service N/A");
    }

    protected Path create(String string, String ... stringArray) {
        return this.create(string, GenericUtils.unmodifiableList(stringArray));
    }

    protected Path create(String string, Collection collection) {
        return this.create(string, GenericUtils.unmodifiableList(collection));
    }

    protected abstract Path create(String var1, List var2);

    private static /* synthetic */ boolean lambda$getPathMatcher$0(Pattern pattern, Path path) {
        Matcher matcher = pattern.matcher(path.toString());
        return matcher.matches();
    }
}

