/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.root;

import java.nio.channels.SeekableByteChannel;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Set;
import org.apache.sshd.common.file.root.RootedDirectoryStream;
import org.apache.sshd.common.file.root.RootedFileSystem;

public class RootedSecureDirectoryStream
extends RootedDirectoryStream
implements SecureDirectoryStream {
    public RootedSecureDirectoryStream(RootedFileSystem rootedFileSystem, SecureDirectoryStream secureDirectoryStream) {
        super(rootedFileSystem, secureDirectoryStream);
    }

    public SecureDirectoryStream newDirectoryStream(Path path, LinkOption ... linkOptionArray) {
        return new RootedSecureDirectoryStream(this.rfs, this.delegate().newDirectoryStream(this.fixPath(path), linkOptionArray));
    }

    protected Path fixPath(Path path) {
        if (path.isAbsolute()) {
            return this.rfs.provider().unroot(path);
        }
        return this.rfs.getRootFileSystem().getPath(path.toString(), new String[0]);
    }

    public SeekableByteChannel newByteChannel(Path path, Set set, FileAttribute ... fileAttributeArray) {
        return this.delegate().newByteChannel(this.fixPath(path), set, fileAttributeArray);
    }

    public void deleteFile(Path path) {
        this.delegate().deleteFile(this.fixPath(path));
    }

    public void deleteDirectory(Path path) {
        this.delegate().deleteDirectory(this.fixPath(path));
    }

    public void move(Path path, SecureDirectoryStream secureDirectoryStream, Path path2) {
        this.delegate().move(this.fixPath(path), secureDirectoryStream, path2);
    }

    public FileAttributeView getFileAttributeView(Class clazz) {
        return this.delegate().getFileAttributeView(clazz);
    }

    public FileAttributeView getFileAttributeView(Path path, Class clazz, LinkOption ... linkOptionArray) {
        return this.delegate().getFileAttributeView(path, clazz, linkOptionArray);
    }

    private SecureDirectoryStream delegate() {
        return (SecureDirectoryStream)this.delegate;
    }
}

