/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.root;

import java.io.File;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.List;
import org.apache.sshd.common.file.root.RootedFileSystem;
import org.apache.sshd.common.file.util.BaseFileSystem;
import org.apache.sshd.common.file.util.BasePath;

public class RootedPath
extends BasePath {
    public RootedPath(RootedFileSystem rootedFileSystem, String string, List list) {
        super(rootedFileSystem, string, list);
    }

    @Override
    public File toFile() {
        RootedPath rootedPath = (RootedPath)this.toAbsolutePath();
        RootedFileSystem rootedFileSystem = (RootedFileSystem)this.getFileSystem();
        Path path = rootedFileSystem.getRoot();
        for (String string : rootedPath.names) {
            path = path.resolve(string);
        }
        return path.toFile();
    }

    @Override
    public RootedPath toRealPath(LinkOption ... linkOptionArray) {
        RootedPath rootedPath = (RootedPath)this.toAbsolutePath();
        BaseFileSystem baseFileSystem = this.getFileSystem();
        FileSystemProvider fileSystemProvider = ((FileSystem)baseFileSystem).provider();
        fileSystemProvider.checkAccess(rootedPath, new AccessMode[0]);
        return rootedPath;
    }
}

