/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.root;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.file.root.RootedDirectoryStream;
import org.apache.sshd.common.file.root.RootedFileSystem;
import org.apache.sshd.common.file.root.RootedFileSystemUtils;
import org.apache.sshd.common.file.root.RootedPath;
import org.apache.sshd.common.file.root.RootedSecureDirectoryStream;
import org.apache.sshd.common.util.io.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootedFileSystemProvider
extends FileSystemProvider {
    protected final Logger log;
    private final Map fileSystems = new HashMap();

    public RootedFileSystemProvider() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public String getScheme() {
        return "root";
    }

    public FileSystem newFileSystem(URI uRI, Map map) {
        return this.newFileSystem(uRI, this.uriToPath(uRI), map);
    }

    @Override
    public FileSystem getFileSystem(URI uRI) {
        return this.getFileSystem(this.uriToPath(uRI));
    }

    public FileSystem newFileSystem(Path path, Map map) {
        return this.newFileSystem(path, path, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem newFileSystem(Object object, Path path, Map map) {
        Path path2 = RootedFileSystemProvider.ensureDirectory(path).toRealPath(new LinkOption[0]);
        RootedFileSystem rootedFileSystem = null;
        Map map2 = this.fileSystems;
        synchronized (map2) {
            if (!this.fileSystems.containsKey(path2)) {
                rootedFileSystem = new RootedFileSystem(this, path, map);
                this.fileSystems.put(path2, rootedFileSystem);
            }
        }
        if (rootedFileSystem == null) {
            throw new FileSystemAlreadyExistsException("newFileSystem(" + object + ") already mapped " + path2);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("newFileSystem({}): {}", object, (Object)rootedFileSystem);
        }
        return rootedFileSystem;
    }

    protected Path uriToPath(URI uRI) {
        String string = uRI.getScheme();
        String string2 = this.getScheme();
        if (string == null || !string.equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException("URI scheme (" + string + ") is not '" + string2 + "'");
        }
        String string3 = uRI.getRawSchemeSpecificPart();
        int n2 = string3.indexOf("!/");
        if (n2 != -1) {
            string3 = string3.substring(0, n2);
        }
        try {
            return Paths.get(new URI(string3)).toAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(string3 + ": " + uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    private static Path ensureDirectory(Path path) {
        return IoUtils.ensureDirectory(path, IoUtils.getLinkOptions(true));
    }

    @Override
    public Path getPath(URI uRI) {
        String string = uRI.getSchemeSpecificPart();
        int n2 = string.indexOf("!/");
        if (n2 == -1) {
            throw new IllegalArgumentException("URI: " + uRI + " does not contain path info - e.g., root:file://foo/bar!/");
        }
        FileSystem fileSystem = this.getFileSystem(uRI);
        String string2 = string.substring(n2 + 1);
        Path path = fileSystem.getPath(string2, new String[0]);
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPath({}): {}", (Object)uRI, (Object)path);
        }
        return path;
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... openOptionArray) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            return fileSystemProvider.newInputStream(path2, openOptionArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... openOptionArray) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            return fileSystemProvider.newOutputStream(path2, openOptionArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    public FileChannel newFileChannel(Path path, Set set, FileAttribute ... fileAttributeArray) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            return fileSystemProvider.newFileChannel(path2, set, fileAttributeArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set set, ExecutorService executorService, FileAttribute ... fileAttributeArray) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            return fileSystemProvider.newAsynchronousFileChannel(path2, set, executorService, fileAttributeArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    public SeekableByteChannel newByteChannel(Path path, Set set, FileAttribute ... fileAttributeArray) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            return fileSystemProvider.newByteChannel(path2, set, fileAttributeArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    public DirectoryStream newDirectoryStream(Path path, DirectoryStream.Filter filter) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            return this.root((RootedFileSystem)((RootedPath)path).getFileSystem(), fileSystemProvider.newDirectoryStream(path2, filter));
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    protected DirectoryStream root(RootedFileSystem rootedFileSystem, DirectoryStream directoryStream) {
        if (directoryStream instanceof SecureDirectoryStream) {
            return new RootedSecureDirectoryStream(rootedFileSystem, (SecureDirectoryStream)directoryStream);
        }
        return new RootedDirectoryStream(rootedFileSystem, directoryStream);
    }

    public void createDirectory(Path path, FileAttribute ... fileAttributeArray) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            fileSystemProvider.createDirectory(path2, fileAttributeArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    public void createSymbolicLink(Path path, Path path2, FileAttribute ... fileAttributeArray) {
        RootedFileSystemUtils.validateSafeRelativeSymlink(path2);
        Path path3 = this.unroot(path);
        Path path4 = path2.isAbsolute() ? this.unroot(path2) : path3.getFileSystem().getPath(path2.toString(), new String[0]);
        FileSystemProvider fileSystemProvider = this.provider(path3);
        try {
            fileSystemProvider.createSymbolicLink(path3, path4, fileAttributeArray);
            if (this.log.isDebugEnabled()) {
                this.log.debug("createSymbolicLink({} => {}", (Object)path3, (Object)path4);
            }
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public void createLink(Path path, Path path2) {
        Path path3 = this.unroot(path);
        Path path4 = this.unroot(path2);
        try {
            this.provider(path3).createLink(path3, path4);
            if (this.log.isDebugEnabled()) {
                this.log.debug("createLink({} => {}", (Object)path3, (Object)path4);
            }
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public void delete(Path path) {
        Path path2 = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("delete({}): {}", (Object)path, (Object)path2);
        }
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            fileSystemProvider.delete(path2);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public boolean deleteIfExists(Path path) {
        Path path2 = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("deleteIfExists({}): {}", (Object)path, (Object)path2);
        }
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            return fileSystemProvider.deleteIfExists(path2);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public Path readSymbolicLink(Path path) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            Path path3 = fileSystemProvider.readSymbolicLink(path2);
            Path path4 = this.root((RootedFileSystem)path.getFileSystem(), path3);
            if (this.log.isTraceEnabled()) {
                this.log.trace("readSymbolicLink({})[{}]: {}[{}]", new Object[]{path, path2, path4, path3});
            }
            return path4;
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public void copy(Path path, Path path2, CopyOption ... copyOptionArray) {
        Path path3 = this.unroot(path);
        Path path4 = this.unroot(path2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("copy({})[{}]: {}[{}]", new Object[]{path, path3, path2, path4});
        }
        FileSystemProvider fileSystemProvider = this.provider(path3);
        try {
            fileSystemProvider.copy(path3, path4, copyOptionArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public void move(Path path, Path path2, CopyOption ... copyOptionArray) {
        Path path3 = this.unroot(path);
        Path path4 = this.unroot(path2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("move({})[{}]: {}[{}]", new Object[]{path, path3, path2, path4});
        }
        FileSystemProvider fileSystemProvider = this.provider(path3);
        try {
            fileSystemProvider.move(path3, path4, copyOptionArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public boolean isSameFile(Path path, Path path2) {
        Path path3 = this.unroot(path);
        Path path4 = this.unroot(path2);
        FileSystemProvider fileSystemProvider = this.provider(path3);
        try {
            return fileSystemProvider.isSameFile(path3, path4);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public boolean isHidden(Path path) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            return fileSystemProvider.isHidden(path2);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public FileStore getFileStore(Path path) {
        RootedFileSystem rootedFileSystem = this.getFileSystem(path);
        Path path2 = rootedFileSystem.getRoot();
        try {
            return Files.getFileStore(path2);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootedFileSystem getFileSystem(Path path) {
        Path path2 = this.unroot(path);
        Path path3 = null;
        RootedFileSystem rootedFileSystem = null;
        Map map = this.fileSystems;
        synchronized (map) {
            for (Map.Entry entry : this.fileSystems.entrySet()) {
                Path path4 = (Path)entry.getKey();
                RootedFileSystem rootedFileSystem2 = (RootedFileSystem)entry.getValue();
                if (path2.equals(path4)) {
                    return rootedFileSystem2;
                }
                if (!path2.startsWith(path4) || path3 != null && path3.getNameCount() >= path4.getNameCount()) continue;
                path3 = path4;
                rootedFileSystem = rootedFileSystem2;
            }
        }
        if (rootedFileSystem == null) {
            throw new FileSystemNotFoundException(path.toString());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("getFileSystem({}): {}", (Object)path, rootedFileSystem);
        }
        return rootedFileSystem;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... accessModeArray) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            fileSystemProvider.checkAccess(path2, accessModeArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    public FileAttributeView getFileAttributeView(Path path, Class clazz, LinkOption ... linkOptionArray) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        return fileSystemProvider.getFileAttributeView(path2, clazz, linkOptionArray);
    }

    public BasicFileAttributes readAttributes(Path path, Class clazz, LinkOption ... linkOptionArray) {
        Path path2 = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("readAttributes({})[{}] type={}", new Object[]{path, path2, clazz.getSimpleName()});
        }
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            return fileSystemProvider.readAttributes(path2, clazz, linkOptionArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    public Map readAttributes(Path path, String string, LinkOption ... linkOptionArray) {
        Path path2 = this.unroot(path);
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            Map<String, Object> map = fileSystemProvider.readAttributes(path2, string, linkOptionArray);
            if (this.log.isTraceEnabled()) {
                this.log.trace("readAttributes({})[{}] {}: {}", new Object[]{path, path2, string, map});
            }
            return map;
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    @Override
    public void setAttribute(Path path, String string, Object object, LinkOption ... linkOptionArray) {
        Path path2 = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("setAttribute({})[{}] {}={}", new Object[]{path, path2, string, object});
        }
        FileSystemProvider fileSystemProvider = this.provider(path2);
        try {
            fileSystemProvider.setAttribute(path2, string, object, linkOptionArray);
        }
        catch (IOException iOException) {
            throw this.translateIoException(iOException, path);
        }
    }

    protected FileSystemProvider provider(Path path) {
        FileSystem fileSystem = path.getFileSystem();
        return fileSystem.provider();
    }

    protected Path root(RootedFileSystem rootedFileSystem, Path path) {
        if (path.isAbsolute()) {
            if (path.startsWith(rootedFileSystem.getRoot())) {
                if (path.getNameCount() == rootedFileSystem.getRoot().getNameCount()) {
                    return rootedFileSystem.getPath("/", new String[0]);
                }
                String string = "/" + path.getName(rootedFileSystem.getRoot().getNameCount());
                String[] stringArray = new String[path.getNameCount() - rootedFileSystem.getRoot().getNameCount() - 1];
                int n2 = 0;
                for (int i2 = 1 + rootedFileSystem.getRoot().getNameCount(); i2 < path.getNameCount(); ++i2) {
                    stringArray[n2++] = path.getName(i2).toString();
                }
                return rootedFileSystem.getPath(string, stringArray);
            }
            Path path2 = rootedFileSystem.getRoot();
            Path path3 = path2.relativize(path);
            return rootedFileSystem.getPath("/" + path3, new String[0]);
        }
        return rootedFileSystem.getPath(path.toString(), new String[0]);
    }

    protected Path unroot(Path path) {
        Objects.requireNonNull(path, "No path to unroot");
        if (!(path instanceof RootedPath)) {
            throw new ProviderMismatchException("unroot(" + path + ") is not a " + RootedPath.class.getSimpleName() + " but rather a " + path.getClass().getSimpleName());
        }
        return this.resolveLocalPath((RootedPath)path);
    }

    protected Path resolveLocalPath(RootedPath rootedPath) {
        Objects.requireNonNull(rootedPath, "No rooted path to resolve");
        RootedFileSystem rootedFileSystem = (RootedFileSystem)rootedPath.getFileSystem();
        Path path = rootedFileSystem.getRoot();
        Path path2 = IoUtils.chroot(path, rootedPath);
        if (!path2.normalize().startsWith(path)) {
            throw new InvalidPathException(path.toString(), "Not under root");
        }
        return path2;
    }

    private IOException translateIoException(IOException iOException, Path path) {
        RootedPath rootedPath = (RootedPath)path;
        Path path2 = ((RootedFileSystem)rootedPath.getFileSystem()).getRoot();
        if (iOException instanceof FileSystemException) {
            String string = this.fixExceptionFileName(path2, path, ((FileSystemException)iOException).getFile());
            String string2 = this.fixExceptionFileName(path2, path, ((FileSystemException)iOException).getOtherFile());
            String string3 = ((FileSystemException)iOException).getReason();
            if (NoSuchFileException.class.equals(iOException.getClass())) {
                return new NoSuchFileException(string, string2, string3);
            }
            if (FileSystemLoopException.class.equals(iOException.getClass())) {
                return new FileSystemLoopException(string);
            }
            if (NotDirectoryException.class.equals(iOException.getClass())) {
                return new NotDirectoryException(string);
            }
            if (DirectoryNotEmptyException.class.equals(iOException.getClass())) {
                return new DirectoryNotEmptyException(string);
            }
            if (NotLinkException.class.equals(iOException.getClass())) {
                return new NotLinkException(string);
            }
            if (AtomicMoveNotSupportedException.class.equals(iOException.getClass())) {
                return new AtomicMoveNotSupportedException(string, string2, string3);
            }
            if (FileAlreadyExistsException.class.equals(iOException.getClass())) {
                return new FileAlreadyExistsException(string, string2, string3);
            }
            if (AccessDeniedException.class.equals(iOException.getClass())) {
                return new AccessDeniedException(string, string2, string3);
            }
            return new FileSystemException(string, string2, string3);
        }
        if (iOException.getClass().equals(FileNotFoundException.class)) {
            return new FileNotFoundException(iOException.getLocalizedMessage().replace(path2.toString(), ""));
        }
        return iOException;
    }

    private String fixExceptionFileName(Path path, Path path2, String string) {
        if (string == null) {
            return null;
        }
        Path path3 = path.getFileSystem().getPath(string, new String[0]);
        if (path3.getNameCount() == path.getNameCount()) {
            return path2.getFileSystem().getSeparator();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = path.getNameCount(); i2 < path3.getNameCount(); ++i2) {
            stringBuilder.append(path2.getFileSystem().getSeparator());
            stringBuilder.append(path3.getName(i2++));
        }
        return stringBuilder.toString();
    }
}

