/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.root;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.file.root.RootedFileSystemProvider;
import org.apache.sshd.common.file.root.RootedPath;
import org.apache.sshd.common.file.util.BaseFileSystem;

public class RootedFileSystem
extends BaseFileSystem {
    private final Path rootPath;
    private final FileSystem rootFs;

    public RootedFileSystem(RootedFileSystemProvider rootedFileSystemProvider, Path path, Map map) {
        super(rootedFileSystemProvider);
        this.rootPath = Objects.requireNonNull(path, "No root path");
        this.rootFs = path.getFileSystem();
    }

    public FileSystem getRootFileSystem() {
        return this.rootFs;
    }

    public Path getRoot() {
        return this.rootPath;
    }

    @Override
    public RootedFileSystemProvider provider() {
        return (RootedFileSystemProvider)super.provider();
    }

    @Override
    public void close() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("close({})", (Object)this);
        }
    }

    @Override
    public boolean isOpen() {
        return this.rootFs.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.rootFs.isReadOnly();
    }

    public Set supportedFileAttributeViews() {
        return this.rootFs.supportedFileAttributeViews();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.rootFs.getUserPrincipalLookupService();
    }

    @Override
    protected RootedPath create(String string, List list) {
        return new RootedPath(this, string, list);
    }

    @Override
    public Iterable getFileStores() {
        return this.rootFs.getFileStores();
    }

    @Override
    protected boolean hostFsHasWindowsSeparator() {
        return "\\".equals(this.getRoot().getFileSystem().getSeparator());
    }

    public String toString() {
        return this.rootPath.toString();
    }
}

