/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.nonefs;

import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.file.nonefs.NoneFileSystem;

public class NoneFileSystemProvider
extends FileSystemProvider {
    public static final String SCHEME = "none";
    public static final NoneFileSystemProvider INSTANCE = new NoneFileSystemProvider();

    @Override
    public String getScheme() {
        return SCHEME;
    }

    public FileSystem newFileSystem(URI uRI, Map map) {
        return this.getFileSystem(uRI);
    }

    @Override
    public FileSystem getFileSystem(URI uRI) {
        if (!Objects.equals(this.getScheme(), uRI.getScheme())) {
            throw new IllegalArgumentException("Mismatched FS scheme");
        }
        return NoneFileSystem.INSTANCE;
    }

    @Override
    public Path getPath(URI uRI) {
        if (!Objects.equals(this.getScheme(), uRI.getScheme())) {
            throw new IllegalArgumentException("Mismatched FS scheme");
        }
        throw new UnsupportedOperationException("No paths available");
    }

    public SeekableByteChannel newByteChannel(Path path, Set set, FileAttribute ... fileAttributeArray) {
        throw new NoSuchFileException(path.toString());
    }

    public DirectoryStream newDirectoryStream(Path path, DirectoryStream.Filter filter) {
        throw new NoSuchFileException(path.toString());
    }

    public void createDirectory(Path path, FileAttribute ... fileAttributeArray) {
        throw new NoSuchFileException(path.toString());
    }

    @Override
    public void delete(Path path) {
        throw new NoSuchFileException(path.toString());
    }

    @Override
    public void copy(Path path, Path path2, CopyOption ... copyOptionArray) {
        throw new NoSuchFileException(path.toString(), path2.toString(), "N/A");
    }

    @Override
    public void move(Path path, Path path2, CopyOption ... copyOptionArray) {
        throw new NoSuchFileException(path.toString(), path2.toString(), "N/A");
    }

    @Override
    public boolean isSameFile(Path path, Path path2) {
        throw new NoSuchFileException(path.toString(), path2.toString(), "N/A");
    }

    @Override
    public boolean isHidden(Path path) {
        throw new NoSuchFileException(path.toString());
    }

    @Override
    public FileStore getFileStore(Path path) {
        throw new NoSuchFileException(path.toString());
    }

    @Override
    public void checkAccess(Path path, AccessMode ... accessModeArray) {
        throw new NoSuchFileException(path.toString());
    }

    public FileAttributeView getFileAttributeView(Path path, Class clazz, LinkOption ... linkOptionArray) {
        return null;
    }

    public BasicFileAttributes readAttributes(Path path, Class clazz, LinkOption ... linkOptionArray) {
        throw new NoSuchFileException(path.toString());
    }

    public Map readAttributes(Path path, String string, LinkOption ... linkOptionArray) {
        throw new NoSuchFileException(path.toString());
    }

    @Override
    public void setAttribute(Path path, String string, Object object, LinkOption ... linkOptionArray) {
        throw new NoSuchFileException(path.toString());
    }
}

