/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.nativefs;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class NativeFileSystemFactory
extends AbstractLoggingBean
implements FileSystemFactory {
    public static final String DEFAULT_USERS_HOME = OsUtils.isWin32() ? "C:\\Users" : (OsUtils.isOSX() ? "/Users" : "/home");
    public static final NativeFileSystemFactory INSTANCE = new NativeFileSystemFactory();
    private boolean createHome;
    private String usersHomeDir = DEFAULT_USERS_HOME;

    public NativeFileSystemFactory() {
        this(false);
    }

    public NativeFileSystemFactory(boolean bl2) {
        this.createHome = bl2;
    }

    public String getUsersHomeDir() {
        return this.usersHomeDir;
    }

    public void setUsersHomeDir(String string) {
        this.usersHomeDir = ValidateUtils.checkNotNullAndNotEmpty(string, "No users home dir");
    }

    public boolean isCreateHome() {
        return this.createHome;
    }

    public void setCreateHome(boolean bl2) {
        this.createHome = bl2;
    }

    @Override
    public Path getUserHomeDir(SessionContext sessionContext) {
        String string = sessionContext.getUsername();
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        String string2 = this.getUsersHomeDir();
        if (GenericUtils.isEmpty(string2)) {
            return null;
        }
        return Paths.get(string2, string).normalize().toAbsolutePath();
    }

    @Override
    public FileSystem createFileSystem(SessionContext sessionContext) {
        if (this.isCreateHome()) {
            Path path = this.getUserHomeDir(sessionContext);
            if (path == null) {
                throw new InvalidPathException(sessionContext.getUsername(), "Cannot resolve home directory");
            }
            if (Files.exists(path, new LinkOption[0])) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    throw new NotDirectoryException(path.toString());
                }
            } else {
                Path path2 = Files.createDirectories(path, new FileAttribute[0]);
                this.log.info("createFileSystem({}) created {}", (Object)sessionContext, (Object)path2);
            }
        }
        return FileSystems.getDefault();
    }
}

