/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public final class DigestUtils {
    private DigestUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static boolean checkSupported(String string) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No algorithm");
        try {
            MessageDigest messageDigest = SecurityUtils.getMessageDigest(string);
            return messageDigest != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Digest findDigestByAlgorithm(String string, Comparator comparator, Collection collection) {
        if (GenericUtils.isEmpty(string) || GenericUtils.isEmpty(collection)) {
            return null;
        }
        for (Digest digest : collection) {
            if (comparator.compare(string, digest.getAlgorithm()) != 0) continue;
            return digest;
        }
        return null;
    }

    public static DigestFactory findFactoryByAlgorithm(String string, Comparator comparator, Collection collection) {
        if (GenericUtils.isEmpty(string) || GenericUtils.isEmpty(collection)) {
            return null;
        }
        for (DigestFactory digestFactory : collection) {
            if (comparator.compare(string, digestFactory.getAlgorithm()) != 0) continue;
            return digestFactory;
        }
        return null;
    }

    public static String getFingerPrint(Factory factory, String string) {
        return DigestUtils.getFingerPrint(factory, string, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Factory factory, String string, Charset charset) {
        return DigestUtils.getFingerPrint((Digest)Objects.requireNonNull(factory, "No factory").create(), string, charset);
    }

    public static String getFingerPrint(Digest digest, String string) {
        return DigestUtils.getFingerPrint(digest, string, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Digest digest, String string, Charset charset) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        return DigestUtils.getFingerPrint(digest, string.getBytes(charset));
    }

    public static String getFingerPrint(Factory factory, byte ... byArray) {
        return DigestUtils.getFingerPrint(factory, byArray, 0, NumberUtils.length(byArray));
    }

    public static String getFingerPrint(Factory factory, byte[] byArray, int n2, int n3) {
        return DigestUtils.getFingerPrint((Digest)Objects.requireNonNull(factory, "No factory").create(), byArray, n2, n3);
    }

    public static String getFingerPrint(Digest digest, byte ... byArray) {
        return DigestUtils.getFingerPrint(digest, byArray, 0, NumberUtils.length(byArray));
    }

    public static String getFingerPrint(Digest digest, byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            return null;
        }
        byte[] byArray2 = DigestUtils.getRawFingerprint(digest, byArray, n2, n3);
        String string = digest.getAlgorithm();
        if (BuiltinDigests.md5.getAlgorithm().equals(string)) {
            return string + ":" + BufferUtils.toHex(':', byArray2).toLowerCase();
        }
        Base64.Encoder encoder = Base64.getEncoder();
        return string.replace("-", "").toUpperCase() + ":" + encoder.encodeToString(byArray2).replaceAll("=", "");
    }

    public static byte[] getRawFingerprint(Digest digest, byte ... byArray) {
        return DigestUtils.getRawFingerprint(digest, byArray, 0, NumberUtils.length(byArray));
    }

    public static byte[] getRawFingerprint(Digest digest, byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            return null;
        }
        Objects.requireNonNull(digest, "No digest").init();
        digest.update(byArray, n2, n3);
        return digest.digest();
    }
}

