/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.digest;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.digest.BaseDigest;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.digest.DigestUtils;
import org.apache.sshd.common.util.GenericUtils;

public enum BuiltinDigests implements DigestFactory
{
    md5("md5", "MD5", 16),
    sha1("sha1", "SHA-1", 20),
    sha224("sha224", "SHA-224", 28),
    sha256("sha256", "SHA-256", 32),
    sha384("sha384", "SHA-384", 48),
    sha512("sha512", "SHA-512", 64);

    public static final Set VALUES;
    private final String algorithm;
    private final int blockSize;
    private final String factoryName;
    private final boolean supported;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinDigests(int n2) {
        void var5_3;
        void var4_2;
        this.factoryName = (String)n2;
        this.algorithm = var4_2;
        this.blockSize = var5_3;
        this.supported = DigestUtils.checkSupported((String)var4_2);
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public final int getBlockSize() {
        return this.blockSize;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public final Digest create() {
        return new BaseDigest(this.getAlgorithm(), this.getBlockSize());
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    public static BuiltinDigests fromString(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (BuiltinDigests builtinDigests : VALUES) {
            if (!string.equalsIgnoreCase(builtinDigests.name())) continue;
            return builtinDigests;
        }
        return null;
    }

    public static BuiltinDigests fromFactory(NamedFactory namedFactory) {
        if (namedFactory == null) {
            return null;
        }
        return BuiltinDigests.fromFactoryName(namedFactory.getName());
    }

    public static BuiltinDigests fromFactoryName(String string) {
        return (BuiltinDigests)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinDigests fromDigest(Digest digest) {
        return BuiltinDigests.fromAlgorithm(digest == null ? null : digest.getAlgorithm());
    }

    public static BuiltinDigests fromAlgorithm(String string) {
        return (BuiltinDigests)DigestUtils.findFactoryByAlgorithm(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinDigests.class));
    }
}

