/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.digest;

import java.security.MessageDigest;
import java.util.Objects;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class BaseDigest
implements Digest {
    private final String algorithm;
    private final int bsize;
    private int h;
    private String s;
    private MessageDigest md;

    public BaseDigest(String string, int n2) {
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(string, "No algorithm");
        ValidateUtils.checkTrue(n2 > 0, "Invalid block size: %d", n2);
        this.bsize = n2;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init() {
        this.md = SecurityUtils.getMessageDigest(this.getAlgorithm());
    }

    @Override
    public void update(byte[] byArray) {
        this.update(byArray, 0, NumberUtils.length(byArray));
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(this.md, "Digest not initialized").update(byArray, n2, n3);
    }

    protected MessageDigest getMessageDigest() {
        return this.md;
    }

    @Override
    public byte[] digest() {
        return Objects.requireNonNull(this.md, "Digest not initialized").digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        BaseDigest baseDigest = this;
        synchronized (baseDigest) {
            if (this.h == 0) {
                this.h = Objects.hashCode(this.getAlgorithm()) + this.getBlockSize();
                if (this.h == 0) {
                    this.h = 1;
                }
            }
        }
        return this.h;
    }

    public int compareTo(Digest digest) {
        String string;
        if (digest == null) {
            return -1;
        }
        if (this == digest) {
            return 0;
        }
        String string2 = this.getAlgorithm();
        int n2 = GenericUtils.safeCompare(string2, string = digest.getAlgorithm(), false);
        if (n2 != 0) {
            return n2;
        }
        n2 = Integer.compare(this.getBlockSize(), digest.getBlockSize());
        if (n2 != 0) {
            return n2;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        int n2 = this.compareTo((Digest)object);
        return n2 == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        BaseDigest baseDigest = this;
        synchronized (baseDigest) {
            if (this.s == null) {
                this.s = this.getClass().getSimpleName() + "[" + this.getAlgorithm() + ":" + this.getBlockSize() + "]";
            }
        }
        return this.s;
    }
}

