/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.writer.openssh;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKeyPairResourceParser;
import org.apache.sshd.common.config.keys.writer.KeyPairResourceWriter;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyEncryptionContext;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyPairResourceWriter$KeyEncryptor;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;

public class OpenSSHKeyPairResourceWriter
implements KeyPairResourceWriter {
    public static final String DASHES = "-----";
    public static final int LINE_LENGTH = 70;
    public static final OpenSSHKeyPairResourceWriter INSTANCE = new OpenSSHKeyPairResourceWriter();
    private static final Pattern VERTICALSPACE = Pattern.compile("\\v");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePrivateKey(KeyPair keyPair, String string, OpenSSHKeyEncryptionContext openSSHKeyEncryptionContext, OutputStream outputStream) {
        Object object;
        Objects.requireNonNull(keyPair, "Cannot write null key");
        String string2 = KeyUtils.getKeyType(keyPair);
        if (GenericUtils.isEmpty(string2)) {
            throw new GeneralSecurityException("Unsupported key: " + keyPair.getClass().getName());
        }
        OpenSSHKeyEncryptionContext openSSHKeyEncryptionContext2 = OpenSSHKeyPairResourceWriter.determineEncryption(openSSHKeyEncryptionContext);
        OpenSSHKeyPairResourceWriter.write(outputStream, "-----BEGIN OPENSSH PRIVATE KEY-----");
        outputStream.write(10);
        String string3 = "none";
        int n2 = 8;
        if (openSSHKeyEncryptionContext2 != null) {
            string3 = openSSHKeyEncryptionContext2.getCipherFactoryName();
            object = BuiltinCiphers.fromFactoryName(string3);
            if (object == null) {
                throw new IllegalArgumentException("Unsupported cipher " + string3);
            }
            n2 = object.getCipherBlockSize();
        }
        object = OpenSSHKeyPairResourceWriter.encodePrivateKey(keyPair, string2, n2, string);
        String string4 = "none";
        byte[] byArray = GenericUtils.EMPTY_BYTE_ARRAY;
        try (SecureByteArrayOutputStream secureByteArrayOutputStream = new SecureByteArrayOutputStream();){
            OpenSSHKeyPairResourceWriter.write(secureByteArrayOutputStream, "openssh-key-v1");
            secureByteArrayOutputStream.write(0);
            if (openSSHKeyEncryptionContext2 != null) {
                OpenSSHKeyPairResourceWriter$KeyEncryptor openSSHKeyPairResourceWriter$KeyEncryptor = new OpenSSHKeyPairResourceWriter$KeyEncryptor(openSSHKeyEncryptionContext2);
                openSSHKeyEncryptionContext2.setPrivateKeyObfuscator(openSSHKeyPairResourceWriter$KeyEncryptor);
                byte[] byArray2 = openSSHKeyPairResourceWriter$KeyEncryptor.applyPrivateKeyCipher((byte[])object, openSSHKeyEncryptionContext2, true);
                Arrays.fill((byte[])object, (byte)0);
                object = byArray2;
                string4 = "bcrypt";
                byArray = openSSHKeyPairResourceWriter$KeyEncryptor.getKdfOptions();
            }
            KeyEntryResolver.encodeString(secureByteArrayOutputStream, string3);
            KeyEntryResolver.encodeString(secureByteArrayOutputStream, string4);
            KeyEntryResolver.writeRLEBytes((OutputStream)secureByteArrayOutputStream, byArray);
            KeyEntryResolver.encodeInt(secureByteArrayOutputStream, 1);
            KeyEntryResolver.writeRLEBytes((OutputStream)secureByteArrayOutputStream, OpenSSHKeyPairResourceWriter.encodePublicKey(keyPair.getPublic(), string2));
            KeyEntryResolver.writeRLEBytes((OutputStream)secureByteArrayOutputStream, (byte[])object);
            OpenSSHKeyPairResourceWriter.write(outputStream, secureByteArrayOutputStream.toByteArray(), 70);
        }
        finally {
            Arrays.fill((byte[])object, (byte)0);
        }
        OpenSSHKeyPairResourceWriter.write(outputStream, "-----END OPENSSH PRIVATE KEY-----");
        outputStream.write(10);
    }

    public static OpenSSHKeyEncryptionContext determineEncryption(OpenSSHKeyEncryptionContext openSSHKeyEncryptionContext) {
        String string;
        String string2 = string = openSSHKeyEncryptionContext == null ? null : openSSHKeyEncryptionContext.getPassword();
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            return openSSHKeyEncryptionContext;
        }
        return null;
    }

    public static byte[] encodePrivateKey(KeyPair keyPair, String string, int n2, String string2) {
        try (SecureByteArrayOutputStream secureByteArrayOutputStream = new SecureByteArrayOutputStream();){
            int n3;
            int n4;
            int n5 = new SecureRandom().nextInt();
            KeyEntryResolver.encodeInt(secureByteArrayOutputStream, n5);
            KeyEntryResolver.encodeInt(secureByteArrayOutputStream, n5);
            KeyEntryResolver.encodeString(secureByteArrayOutputStream, string);
            PrivateKeyEntryDecoder privateKeyEntryDecoder = OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(string);
            if (privateKeyEntryDecoder.encodePrivateKey(secureByteArrayOutputStream, keyPair.getPrivate(), keyPair.getPublic()) == null) {
                throw new GeneralSecurityException("Cannot encode key of type " + string);
            }
            KeyEntryResolver.encodeString(secureByteArrayOutputStream, string2 == null ? "" : string2);
            if (n2 > 1 && (n4 = (n3 = secureByteArrayOutputStream.size()) % n2) != 0) {
                for (int i2 = 1; i2 <= n2 - n4; ++i2) {
                    secureByteArrayOutputStream.write(i2 & 0xFF);
                }
            }
            byte[] byArray = secureByteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] encodePublicKey(PublicKey publicKey, String string) {
        PublicKeyEntryDecoder publicKeyEntryDecoder = KeyUtils.getPublicKeyEntryDecoder(string);
        if (publicKeyEntryDecoder == null) {
            throw new GeneralSecurityException("Unknown key type: " + string);
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            publicKeyEntryDecoder.encodePublicKey(byteArrayOutputStream, publicKey);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(OutputStream outputStream, byte[] byArray, int n2) {
        byte[] byArray2 = Base64.getEncoder().encode(byArray);
        Arrays.fill(byArray, (byte)0);
        try {
            int n3 = byArray2.length;
            for (int i2 = 0; i2 < n3; i2 += n2) {
                if (i2 + n2 <= n3) {
                    outputStream.write(byArray2, i2, n2);
                } else {
                    outputStream.write(byArray2, i2, n3 - i2);
                }
                outputStream.write(10);
            }
        }
        finally {
            Arrays.fill(byArray2, (byte)0);
        }
    }

    @Override
    public void writePublicKey(PublicKey publicKey, String string, OutputStream outputStream) {
        StringBuilder stringBuilder = new StringBuilder(82);
        PublicKeyEntry.appendPublicKeyEntry(stringBuilder, publicKey);
        String string2 = OpenSSHKeyPairResourceWriter.firstLine(string);
        if (GenericUtils.isNotEmpty(string2)) {
            stringBuilder.append(' ').append(string2);
        }
        OpenSSHKeyPairResourceWriter.write(outputStream, stringBuilder.toString());
    }

    public static String firstLine(String string) {
        Matcher matcher;
        if (GenericUtils.isNotEmpty(string) && (matcher = VERTICALSPACE.matcher(string)).find()) {
            return string.substring(0, matcher.start()).trim();
        }
        return string;
    }

    public static void write(OutputStream outputStream, String string) {
        outputStream.write(string.getBytes(StandardCharsets.UTF_8));
    }
}

