/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.writer.openssh;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.loader.AESPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.apache.sshd.common.config.keys.loader.openssh.kdf.BCrypt;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyEncryptionContext;
import org.apache.sshd.common.util.GenericUtils;

public class OpenSSHKeyPairResourceWriter$KeyEncryptor
extends AESPrivateKeyObfuscator {
    public static final int BCRYPT_SALT_LENGTH = 16;
    protected final OpenSSHKeyEncryptionContext options;
    private byte[] kdfOptions;

    public OpenSSHKeyPairResourceWriter$KeyEncryptor(OpenSSHKeyEncryptionContext openSSHKeyEncryptionContext) {
        this.options = Objects.requireNonNull(openSSHKeyEncryptionContext);
    }

    public byte[] getKdfOptions() {
        return this.kdfOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected byte[] deriveEncryptionKey(PrivateKeyEncryptionContext privateKeyEncryptionContext, int n2) {
        byte[] byArray = privateKeyEncryptionContext.getInitVector();
        if (byArray == null) {
            byArray = this.generateInitializationVector(privateKeyEncryptionContext);
        }
        byte[] byArray2 = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = new byte[n2 + byArray.length];
        BCrypt bCrypt = new BCrypt();
        try {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                int n3 = this.options.getKdfRounds();
                byte[] byArray4 = this.convert(this.options.getPassword());
                try {
                    bCrypt.pbkdf(byArray4, byArray2, n3, byArray3);
                }
                finally {
                    if (byArray4 != null) {
                        Arrays.fill(byArray4, (byte)0);
                    }
                }
                KeyEntryResolver.writeRLEBytes((OutputStream)byteArrayOutputStream, byArray2);
                KeyEntryResolver.encodeInt(byteArrayOutputStream, n3);
                this.kdfOptions = byteArrayOutputStream.toByteArray();
                privateKeyEncryptionContext.setInitVector(Arrays.copyOfRange(byArray3, n2, byArray3.length));
                byte[] byArray5 = Arrays.copyOf(byArray3, n2);
                return byArray5;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Arrays.fill(byArray3, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] convert(String string) {
        ByteBuffer byteBuffer;
        if (GenericUtils.isEmpty(string)) {
            return GenericUtils.EMPTY_BYTE_ARRAY;
        }
        char[] cArray = string.toCharArray();
        try {
            byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(cArray));
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        if (byteBuffer.hasArray()) {
            Arrays.fill(byteBuffer.array(), (byte)0);
        }
        return byArray;
    }
}

