/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.writer.openssh;

import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.apache.sshd.common.util.ValidateUtils;

public class OpenSSHKeyEncryptionContext
extends PrivateKeyEncryptionContext {
    public static final int DEFAULT_KDF_ROUNDS = 16;
    public static final String AES = "AES";
    private int kdfRounds = 16;

    public OpenSSHKeyEncryptionContext() {
        this.setCipherMode("CTR");
    }

    @Override
    public String getCipherName() {
        return AES;
    }

    @Override
    public void setCipherName(String string) {
        ValidateUtils.checkTrue(string != null && string.equalsIgnoreCase(AES), "OpenSSHKeyEncryptionContext works only with AES encryption");
    }

    public int getKdfRounds() {
        return this.kdfRounds;
    }

    public void setKdfRounds(int n2) {
        this.kdfRounds = Math.max(16, n2);
    }

    protected String getCipherFactoryName() {
        return this.getCipherName().toLowerCase() + this.getCipherType() + '-' + this.getCipherMode().toLowerCase();
    }
}

