/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.u2f;

import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;

public class SkED25519PublicKey
implements SecurityKeyPublicKey {
    public static final String ALGORITHM = "ED25519-SK";
    private static final long serialVersionUID = 4587115316266869640L;
    private final String appName;
    private final boolean noTouchRequired;
    private final EdDSAPublicKey delegatePublicKey;

    public SkED25519PublicKey(String string, boolean bl2, EdDSAPublicKey edDSAPublicKey) {
        this.appName = string;
        this.noTouchRequired = bl2;
        this.delegatePublicKey = edDSAPublicKey;
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public boolean isNoTouchRequired() {
        return this.noTouchRequired;
    }

    @Override
    public EdDSAPublicKey getDelegatePublicKey() {
        return this.delegatePublicKey;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[appName=" + this.getAppName() + ", noTouchRequired=" + this.isNoTouchRequired() + ", delegatePublicKey=" + this.getDelegatePublicKey() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.appName, this.noTouchRequired, this.delegatePublicKey);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SkED25519PublicKey skED25519PublicKey = (SkED25519PublicKey)object;
        return Objects.equals(this.appName, skED25519PublicKey.appName) && this.noTouchRequired == skED25519PublicKey.noTouchRequired && Objects.equals(this.delegatePublicKey, skED25519PublicKey.delegatePublicKey);
    }
}

