/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.ssh2;

import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyTypeNamesSupport;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.PublicKeyRawDataDecoder;
import org.apache.sshd.common.config.keys.PublicKeyRawDataReader;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class Ssh2PublicKeyEntryDecoder
implements KeyTypeNamesSupport,
PublicKeyEntryResolver,
PublicKeyRawDataDecoder,
PublicKeyRawDataReader {
    public static final NavigableSet SUPPORTED_KEY_TYPES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, "ssh-rsa", "ssh-dss", "ssh-ed25519", KeyPairProvider.ECDSA_SHA2_NISTP256, KeyPairProvider.ECDSA_SHA2_NISTP384, KeyPairProvider.ECDSA_SHA2_NISTP521));
    public static final String BEGIN_MARKER = "BEGIN SSH2 PUBLIC KEY";
    public static final List START_MARKERS = Collections.singletonList("BEGIN SSH2 PUBLIC KEY");
    public static final String END_MARKER = "END SSH2 PUBLIC KEY";
    public static final List STOP_MARKERS = Collections.singletonList("END SSH2 PUBLIC KEY");
    public static final char HEADER_CONTINUATION_INDICATOR = '\\';
    public static final Ssh2PublicKeyEntryDecoder INSTANCE = new Ssh2PublicKeyEntryDecoder();

    @Override
    public NavigableSet getSupportedKeyTypes() {
        return SUPPORTED_KEY_TYPES;
    }

    @Override
    public PublicKey resolve(SessionContext sessionContext, String string, byte[] byArray, Map map) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No key type provided");
        NavigableSet navigableSet = this.getSupportedKeyTypes();
        if (GenericUtils.size(navigableSet) > 0 && navigableSet.contains(string)) {
            return this.decodePublicKey(sessionContext, string, byArray, map);
        }
        throw new InvalidKeySpecException("resolve(" + string + ") not in listed supported types: " + navigableSet);
    }

    @Override
    public PublicKey decodePublicKey(SessionContext sessionContext, String string, InputStream inputStream, Map map) {
        return this.decodePublicKeyByType(sessionContext, string, inputStream, map);
    }

    @Override
    public PublicKey decodePublicKeyByType(SessionContext sessionContext, String string, InputStream inputStream, Map map) {
        PublicKeyEntryDecoder publicKeyEntryDecoder = KeyUtils.getPublicKeyEntryDecoder(string);
        if (publicKeyEntryDecoder == null) {
            throw new InvalidKeySpecException("No decoder for key type=" + string);
        }
        return publicKeyEntryDecoder.decodePublicKeyByType(sessionContext, string, inputStream, map);
    }

    @Override
    public PublicKey readPublicKey(SessionContext sessionContext, NamedResource namedResource, List list) {
        AbstractMap.SimpleImmutableEntry simpleImmutableEntry = KeyPairResourceParser.findMarkerLine(list, START_MARKERS);
        if (simpleImmutableEntry == null) {
            return null;
        }
        int n2 = (Integer)simpleImmutableEntry.getKey();
        String string = (String)list.get(n2);
        if ((simpleImmutableEntry = KeyPairResourceParser.findMarkerLine(list, ++n2, STOP_MARKERS)) == null) {
            throw new StreamCorruptedException("Missing end marker (END SSH2 PUBLIC KEY) after line #" + n2);
        }
        int n3 = (Integer)simpleImmutableEntry.getKey();
        String string2 = (String)list.get(n3);
        Map.Entry entry = this.separateDataLinesFromHeaders(sessionContext, namedResource, string, string2, list.subList(n2, n3));
        Map map = (Map)entry.getKey();
        List list2 = (List)entry.getValue();
        return this.readPublicKey(sessionContext, namedResource, BEGIN_MARKER, END_MARKER, list2 == null ? Collections.emptyList() : list2, map == null ? Collections.emptyMap() : map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey readPublicKey(SessionContext sessionContext, NamedResource namedResource, String string, String string2, List list, Map map) {
        byte[] byArray = KeyPairResourceParser.extractDataBytes(list);
        try {
            PublicKey publicKey = this.readPublicKey(sessionContext, namedResource, string, string2, byArray, map);
            return publicKey;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    public PublicKey readPublicKey(SessionContext sessionContext, NamedResource namedResource, String string, String string2, byte[] byArray, Map map) {
        Map.Entry entry = KeyEntryResolver.decodeString(byArray, 256);
        String string3 = (String)entry.getKey();
        return this.resolve(sessionContext, string3, byArray, map);
    }

    protected Map.Entry separateDataLinesFromHeaders(SessionContext sessionContext, NamedResource namedResource, String string, String string2, List list) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            String string3 = (String)list.get(i2);
            if ((string3 = string3.trim()).isEmpty()) continue;
            int n4 = string3.indexOf(58);
            if (n4 < 0) {
                return new AbstractMap.SimpleImmutableEntry(treeMap, list.subList(i2, n2));
            }
            String string4 = string3.substring(0, n4).trim();
            String string5 = string3.substring(n4 + 1).trim();
            if (string5.charAt((n3 = string5.length()) - 1) == '\\') {
                string5 = string5.substring(0, n3 - 1);
                ++i2;
                while (i2 < n2) {
                    string3 = (String)list.get(i2);
                    if (string3.charAt((n3 = string3.length()) - 1) != '\\') {
                        string5 = string5 + string3;
                        break;
                    }
                    string5 = string5 + string3.substring(0, n3 - 1);
                    ++i2;
                }
            }
            treeMap.put(string4, string5.trim());
        }
        throw new StreamCorruptedException("No viable data lines found in " + namedResource.getName() + " after " + string);
    }
}

