/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.pem.AbstractPEMResourceKeyPairParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.security.SecurityUtils;

public class RSAPEMResourceKeyPairParser
extends AbstractPEMResourceKeyPairParser {
    public static final String BEGIN_MARKER = "BEGIN RSA PRIVATE KEY";
    public static final List BEGINNERS = Collections.unmodifiableList(Collections.singletonList("BEGIN RSA PRIVATE KEY"));
    public static final String END_MARKER = "END RSA PRIVATE KEY";
    public static final List ENDERS = Collections.unmodifiableList(Collections.singletonList("END RSA PRIVATE KEY"));
    public static final String RSA_OID = "1.2.840.113549.1.1.1";
    public static final RSAPEMResourceKeyPairParser INSTANCE = new RSAPEMResourceKeyPairParser();

    public RSAPEMResourceKeyPairParser() {
        super("RSA", RSA_OID, BEGINNERS, ENDERS);
    }

    @Override
    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string, String string2, FilePasswordProvider filePasswordProvider, InputStream inputStream, Map map) {
        KeyPair keyPair = RSAPEMResourceKeyPairParser.decodeRSAKeyPair(SecurityUtils.getKeyFactory("RSA"), inputStream, false);
        return Collections.singletonList(keyPair);
    }

    public static KeyPair decodeRSAKeyPair(KeyFactory keyFactory, InputStream inputStream, boolean bl2) {
        ASN1Object aSN1Object;
        try (DERParser dERParser = new DERParser(NoCloseInputStream.resolveInputStream(inputStream, bl2));){
            aSN1Object = dERParser.readObject();
        }
        if (!ASN1Type.SEQUENCE.equals((Object)aSN1Object.getObjType())) {
            throw new IOException("Invalid DER: not a sequence: " + (Object)((Object)aSN1Object.getObjType()));
        }
        dERParser = aSN1Object.createParser();
        var5_4 = null;
        try {
            ASN1Object aSN1Object2 = dERParser.readObject();
            if (aSN1Object2 == null) {
                throw new StreamCorruptedException("No version");
            }
            BigInteger bigInteger = aSN1Object2.asInteger();
            if (!BigInteger.ZERO.equals(bigInteger)) {
                throw new StreamCorruptedException("Multi-primes N/A");
            }
            BigInteger bigInteger2 = dERParser.readObject().asInteger();
            BigInteger bigInteger3 = dERParser.readObject().asInteger();
            PublicKey publicKey = keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger2, bigInteger3));
            BigInteger bigInteger4 = dERParser.readObject().asInteger();
            BigInteger bigInteger5 = dERParser.readObject().asInteger();
            BigInteger bigInteger6 = dERParser.readObject().asInteger();
            BigInteger bigInteger7 = dERParser.readObject().asInteger();
            BigInteger bigInteger8 = dERParser.readObject().asInteger();
            BigInteger bigInteger9 = dERParser.readObject().asInteger();
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, bigInteger9);
            PrivateKey privateKey = keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            return keyPair;
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (dERParser != null) {
                if (var5_4 != null) {
                    try {
                        dERParser.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    dERParser.close();
                }
            }
        }
    }
}

