/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.List;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERParser;

public class PKCS8PrivateKeyInfo {
    private BigInteger version;
    private List algorithmIdentifier;
    private ASN1Object algorithmParameter;
    private ASN1Object privateKeyBytes;

    public PKCS8PrivateKeyInfo() {
    }

    public PKCS8PrivateKeyInfo(byte[] byArray) {
        this.decode(byArray);
    }

    public PKCS8PrivateKeyInfo(DERParser dERParser) {
        this(dERParser.readObject());
    }

    public PKCS8PrivateKeyInfo(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public void setVersion(BigInteger bigInteger) {
        this.version = bigInteger;
    }

    public List getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public void setAlgorithmIdentifier(List list) {
        this.algorithmIdentifier = list;
    }

    public ASN1Object getAlgorithmParameter() {
        return this.algorithmParameter;
    }

    public void setAlgorithmParameter(ASN1Object aSN1Object) {
        this.algorithmParameter = aSN1Object;
    }

    public ASN1Object getPrivateKeyBytes() {
        return this.privateKeyBytes;
    }

    public void setPrivateKeyBytes(ASN1Object aSN1Object) {
        this.privateKeyBytes = aSN1Object;
    }

    public void decode(byte[] byArray) {
        try (DERParser dERParser = new DERParser(byArray);){
            this.decode(dERParser);
        }
    }

    public void decode(DERParser dERParser) {
        this.decode(dERParser.readObject());
    }

    public void decode(ASN1Object aSN1Object) {
        ASN1Type aSN1Type = aSN1Object.getObjType();
        if (aSN1Type != ASN1Type.SEQUENCE) {
            throw new StreamCorruptedException("Not a top level sequence: " + (Object)((Object)aSN1Type));
        }
        try (DERParser dERParser = aSN1Object.createParser();){
            ASN1Object aSN1Object2 = dERParser.readObject();
            if (aSN1Object2 == null) {
                throw new StreamCorruptedException("No version");
            }
            this.setVersion(aSN1Object2.asInteger());
            ASN1Object aSN1Object3 = dERParser.readObject();
            if (aSN1Object3 == null) {
                throw new StreamCorruptedException("No private key algorithm");
            }
            aSN1Type = aSN1Object.getObjType();
            if (aSN1Type != ASN1Type.SEQUENCE) {
                throw new StreamCorruptedException("Not an algorithm parameters sequence: " + (Object)((Object)aSN1Type));
            }
            try (Object object = aSN1Object3.createParser();){
                ASN1Object aSN1Object4 = ((DERParser)object).readObject();
                this.setAlgorithmIdentifier(aSN1Object4.asOID());
                ASN1Object aSN1Object5 = ((DERParser)object).readObject();
                ASN1Type aSN1Type2 = aSN1Type = aSN1Object5 == null ? ASN1Type.NULL : aSN1Object5.getObjType();
                if (aSN1Type != ASN1Type.NULL) {
                    this.setAlgorithmParameter(aSN1Object5);
                }
            }
            object = dERParser.readObject();
            if (object == null) {
                throw new StreamCorruptedException("No private key data");
            }
            aSN1Type = ((ASN1Object)object).getObjType();
            if (aSN1Type != ASN1Type.OCTET_STRING) {
                throw new StreamCorruptedException("Private key data not an " + (Object)((Object)ASN1Type.OCTET_STRING) + ": " + (Object)((Object)aSN1Type));
            }
            this.setPrivateKeyBytes((ASN1Object)object);
        }
    }

    public void clear() {
        this.setVersion(null);
        this.setAlgorithmIdentifier(null);
        this.setPrivateKeyBytes(null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[version=" + this.getVersion() + ", algorithmIdentifier=" + this.getAlgorithmIdentifier() + "]";
    }
}

