/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.CredentialException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.loader.pem.AbstractPEMResourceKeyPairParser;
import org.apache.sshd.common.config.keys.loader.pem.ECDSAPEMResourceKeyPairParser;
import org.apache.sshd.common.config.keys.loader.pem.KeyPairPEMResourceParser;
import org.apache.sshd.common.config.keys.loader.pem.PEMResourceParserUtils;
import org.apache.sshd.common.config.keys.loader.pem.PKCS8PrivateKeyInfo;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.security.Decryptor;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.Ed25519PEMResourceKeyParser;

public class PKCS8PEMResourceKeyPairParser
extends AbstractPEMResourceKeyPairParser {
    public static final String BEGIN_MARKER = "BEGIN PRIVATE KEY";
    public static final String BEGIN_ENCRYPTED_MARKER = "BEGIN ENCRYPTED PRIVATE KEY";
    public static final List BEGINNERS = GenericUtils.unmodifiableList("BEGIN PRIVATE KEY", "BEGIN ENCRYPTED PRIVATE KEY");
    public static final String END_MARKER = "END PRIVATE KEY";
    public static final String END_ENCRYPTED_MARKER = "END ENCRYPTED PRIVATE KEY";
    public static final List ENDERS = GenericUtils.unmodifiableList("END PRIVATE KEY", "END ENCRYPTED PRIVATE KEY");
    public static final String PKCS8_FORMAT = "PKCS#8";
    public static final PKCS8PEMResourceKeyPairParser INSTANCE = new PKCS8PEMResourceKeyPairParser();

    public PKCS8PEMResourceKeyPairParser() {
        super(PKCS8_FORMAT, PKCS8_FORMAT, BEGINNERS, ENDERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string, String string2, FilePasswordProvider filePasswordProvider, InputStream inputStream, Map map) {
        byte[] byArray = IoUtils.toByteArray(inputStream);
        if (string.contains(BEGIN_ENCRYPTED_MARKER)) {
            return this.decryptKeyPairs(sessionContext, namedResource, filePasswordProvider, byArray);
        }
        PKCS8PrivateKeyInfo pKCS8PrivateKeyInfo = new PKCS8PrivateKeyInfo(byArray);
        try {
            Collection collection = this.extractKeyPairs(byArray, pKCS8PrivateKeyInfo);
            return collection;
        }
        finally {
            pKCS8PrivateKeyInfo.clear();
            Arrays.fill(byArray, (byte)0);
        }
    }

    public Collection decryptKeyPairs(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider filePasswordProvider, byte[] byArray) {
        if (filePasswordProvider == null) {
            throw new CredentialException("Missing password provider for encrypted resource=" + namedResource);
        }
        Decryptor decryptor = SecurityUtils.getBouncycastleEncryptedPrivateKeyInfoDecryptor();
        Collection collection = (Collection)filePasswordProvider.decode(sessionContext, namedResource, string -> {
            char[] cArray = string.toCharArray();
            try {
                Collection collection;
                byte[] byArray2 = decryptor.decrypt(byArray, cArray);
                PKCS8PrivateKeyInfo pKCS8PrivateKeyInfo = new PKCS8PrivateKeyInfo(byArray2);
                try {
                    collection = this.extractKeyPairs(byArray2, pKCS8PrivateKeyInfo);
                    pKCS8PrivateKeyInfo.clear();
                }
                catch (Throwable throwable) {
                    pKCS8PrivateKeyInfo.clear();
                    Arrays.fill(byArray2, (byte)0);
                    throw throwable;
                }
                Arrays.fill(byArray2, (byte)0);
                return collection;
            }
            finally {
                Arrays.fill(cArray, '\u0000');
            }
        });
        return collection == null ? Collections.emptyList() : collection;
    }

    public Collection extractKeyPairs(byte[] byArray, PKCS8PrivateKeyInfo pKCS8PrivateKeyInfo) {
        KeyPair keyPair;
        List list = pKCS8PrivateKeyInfo.getAlgorithmIdentifier();
        String string = GenericUtils.join((Iterable)list, '.');
        if (SecurityUtils.isECCSupported() && "1.2.840.10045.2.1".equals(string)) {
            ASN1Object aSN1Object = pKCS8PrivateKeyInfo.getPrivateKeyBytes();
            ASN1Object aSN1Object2 = pKCS8PrivateKeyInfo.getAlgorithmParameter();
            ASN1Type aSN1Type = aSN1Object2 == null ? ASN1Type.NULL : aSN1Object2.getObjType();
            List list2 = aSN1Type == ASN1Type.NULL ? Collections.emptyList() : aSN1Object2.asOID();
            ECCurves eCCurves = null;
            if (GenericUtils.isNotEmpty(list2) && (eCCurves = ECCurves.fromOIDValue(list2)) == null) {
                throw new NoSuchAlgorithmException("Cannot match EC curve OID=" + list2);
            }
            try (DERParser dERParser = aSN1Object.createParser();){
                keyPair = ECDSAPEMResourceKeyPairParser.parseECKeyPair(eCCurves, dERParser);
            }
        } else if (SecurityUtils.isEDDSACurveSupported() && "1.3.101.112".endsWith(string)) {
            ASN1Object aSN1Object = pKCS8PrivateKeyInfo.getPrivateKeyBytes();
            keyPair = Ed25519PEMResourceKeyParser.decodeEd25519KeyPair(aSN1Object.getPureValueBytes());
        } else {
            PrivateKey privateKey = PKCS8PEMResourceKeyPairParser.decodePEMPrivateKeyPKCS8(list, byArray);
            PublicKey publicKey = (PublicKey)ValidateUtils.checkNotNull((Object)KeyUtils.recoverPublicKey(privateKey), "Failed to recover public key of OID=%s", (Object)list);
            keyPair = new KeyPair(publicKey, privateKey);
        }
        return Collections.singletonList(keyPair);
    }

    public static PrivateKey decodePEMPrivateKeyPKCS8(List list, byte[] byArray) {
        ValidateUtils.checkNotNullAndNotEmpty(list, "No PKCS8 algorithm OID", new Object[0]);
        return PKCS8PEMResourceKeyPairParser.decodePEMPrivateKeyPKCS8(GenericUtils.join((Iterable)list, '.'), byArray);
    }

    public static PrivateKey decodePEMPrivateKeyPKCS8(String string, byte[] byArray) {
        KeyPairPEMResourceParser keyPairPEMResourceParser = PEMResourceParserUtils.getPEMResourceParserByOid(ValidateUtils.checkNotNullAndNotEmpty(string, "No PKCS8 algorithm OID"));
        if (keyPairPEMResourceParser == null) {
            throw new NoSuchAlgorithmException("decodePEMPrivateKeyPKCS8(" + string + ") unknown algorithm identifier");
        }
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(keyPairPEMResourceParser.getAlgorithm(), "No parser algorithm");
        KeyFactory keyFactory = SecurityUtils.getKeyFactory(string2);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }
}

