/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.pem.DSSPEMResourceKeyPairParser;
import org.apache.sshd.common.config.keys.loader.pem.ECDSAPEMResourceKeyPairParser;
import org.apache.sshd.common.config.keys.loader.pem.KeyPairPEMResourceParser;
import org.apache.sshd.common.config.keys.loader.pem.PEMResourceParserUtils$1;
import org.apache.sshd.common.config.keys.loader.pem.PKCS8PEMResourceKeyPairParser;
import org.apache.sshd.common.config.keys.loader.pem.RSAPEMResourceKeyPairParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class PEMResourceParserUtils {
    public static final KeyPairResourceParser PROXY = new PEMResourceParserUtils$1();
    private static final Map BY_OID_MAP = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final Map BY_ALGORITHM_MAP = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final AtomicReference PROXY_HOLDER = new AtomicReference<KeyPairResourceParser>(KeyPairResourceParser.EMPTY);

    private PEMResourceParserUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPEMResourceParser(KeyPairPEMResourceParser keyPairPEMResourceParser) {
        Objects.requireNonNull(keyPairPEMResourceParser, "No parser to register");
        Map map = BY_OID_MAP;
        synchronized (map) {
            BY_OID_MAP.put(ValidateUtils.checkNotNullAndNotEmpty(keyPairPEMResourceParser.getAlgorithmIdentifier(), "No OID value"), keyPairPEMResourceParser);
        }
        map = BY_ALGORITHM_MAP;
        synchronized (map) {
            BY_ALGORITHM_MAP.put(ValidateUtils.checkNotNullAndNotEmpty(keyPairPEMResourceParser.getAlgorithm(), "No algorithm value"), keyPairPEMResourceParser);
            PROXY_HOLDER.set(KeyPairResourceParser.aggregate(new ArrayList(BY_ALGORITHM_MAP.values())));
        }
    }

    public static KeyPairPEMResourceParser getPEMResourceParserByOidValues(Collection collection) {
        return PEMResourceParserUtils.getPEMResourceParserByOid(GenericUtils.join((Iterable)collection, '.'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPairPEMResourceParser getPEMResourceParserByOid(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        Map map = BY_OID_MAP;
        synchronized (map) {
            return (KeyPairPEMResourceParser)BY_OID_MAP.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPairPEMResourceParser getPEMResourceParserByAlgorithm(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        Map map = BY_ALGORITHM_MAP;
        synchronized (map) {
            return (KeyPairPEMResourceParser)BY_ALGORITHM_MAP.get(string);
        }
    }

    static /* synthetic */ AtomicReference access$000() {
        return PROXY_HOLDER;
    }

    static {
        PEMResourceParserUtils.registerPEMResourceParser(RSAPEMResourceKeyPairParser.INSTANCE);
        PEMResourceParserUtils.registerPEMResourceParser(DSSPEMResourceKeyPairParser.INSTANCE);
        PEMResourceParserUtils.registerPEMResourceParser(ECDSAPEMResourceKeyPairParser.INSTANCE);
        PEMResourceParserUtils.registerPEMResourceParser(PKCS8PEMResourceKeyPairParser.INSTANCE);
    }
}

