/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.pem.AbstractPEMResourceKeyPairParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.security.SecurityUtils;

public class ECDSAPEMResourceKeyPairParser
extends AbstractPEMResourceKeyPairParser {
    public static final String BEGIN_MARKER = "BEGIN EC PRIVATE KEY";
    public static final List BEGINNERS = Collections.unmodifiableList(Collections.singletonList("BEGIN EC PRIVATE KEY"));
    public static final String END_MARKER = "END EC PRIVATE KEY";
    public static final List ENDERS = Collections.unmodifiableList(Collections.singletonList("END EC PRIVATE KEY"));
    public static final String ECDSA_OID = "1.2.840.10045.2.1";
    public static final ECDSAPEMResourceKeyPairParser INSTANCE = new ECDSAPEMResourceKeyPairParser();

    public ECDSAPEMResourceKeyPairParser() {
        super("EC", ECDSA_OID, BEGINNERS, ENDERS);
    }

    @Override
    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string, String string2, FilePasswordProvider filePasswordProvider, InputStream inputStream, Map map) {
        KeyPair keyPair = ECDSAPEMResourceKeyPairParser.parseECKeyPair(inputStream, false);
        return Collections.singletonList(keyPair);
    }

    public static KeyPair parseECKeyPair(InputStream inputStream, boolean bl2) {
        try (DERParser dERParser = new DERParser(NoCloseInputStream.resolveInputStream(inputStream, bl2));){
            KeyPair keyPair = ECDSAPEMResourceKeyPairParser.parseECKeyPair(null, dERParser);
            return keyPair;
        }
    }

    public static KeyPair parseECKeyPair(ECCurves eCCurves, DERParser dERParser) {
        ASN1Object aSN1Object = dERParser.readObject();
        Map.Entry entry = ECDSAPEMResourceKeyPairParser.decodeECPrivateKeySpec(eCCurves, aSN1Object);
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EC");
        ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic((KeySpec)entry.getKey());
        ECPrivateKey eCPrivateKey = (ECPrivateKey)keyFactory.generatePrivate((KeySpec)entry.getValue());
        return new KeyPair(eCPublicKey, eCPrivateKey);
    }

    public static Map.Entry decodeECPrivateKeySpec(ECCurves eCCurves, ASN1Object aSN1Object) {
        ASN1Type aSN1Type;
        ASN1Type aSN1Type2 = aSN1Type = aSN1Object == null ? null : aSN1Object.getObjType();
        if (!ASN1Type.SEQUENCE.equals((Object)aSN1Type)) {
            throw new IOException("Invalid DER: not a sequence: " + (Object)((Object)aSN1Type));
        }
        try (DERParser dERParser = aSN1Object.createParser();){
            Map.Entry entry = ECDSAPEMResourceKeyPairParser.decodeECPrivateKeySpec(eCCurves, dERParser);
            ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)entry.getKey();
            ASN1Object aSN1Object2 = (ASN1Object)entry.getValue();
            ECPoint eCPoint = aSN1Object2 == null ? ECDSAPEMResourceKeyPairParser.decodeECPublicKeyValue(dERParser) : ECDSAPEMResourceKeyPairParser.decodeECPointData(aSN1Object2);
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCPrivateKeySpec.getParams());
            AbstractMap.SimpleImmutableEntry<ECPublicKeySpec, ECPrivateKeySpec> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<ECPublicKeySpec, ECPrivateKeySpec>(eCPublicKeySpec, eCPrivateKeySpec);
            return simpleImmutableEntry;
        }
    }

    public static Map.Entry decodeECPrivateKeySpec(ECCurves eCCurves, DERParser dERParser) {
        ECCurves eCCurves2;
        ASN1Object aSN1Object = dERParser.readObject();
        if (aSN1Object == null) {
            throw new StreamCorruptedException("No version");
        }
        BigInteger bigInteger = aSN1Object.asInteger();
        if (!BigInteger.ONE.equals(bigInteger)) {
            throw new StreamCorruptedException("Bad version value: " + bigInteger);
        }
        ASN1Object aSN1Object2 = dERParser.readObject();
        if (aSN1Object2 == null) {
            throw new StreamCorruptedException("No private key value");
        }
        ASN1Type aSN1Type = aSN1Object2.getObjType();
        if (!ASN1Type.OCTET_STRING.equals((Object)aSN1Type)) {
            throw new StreamCorruptedException("Non-matching private key object type: " + (Object)((Object)aSN1Type));
        }
        Map.Entry entry = ECDSAPEMResourceKeyPairParser.parseCurveParameter(dERParser);
        ECCurves eCCurves3 = eCCurves2 = entry == null ? null : (ECCurves)entry.getKey();
        if (eCCurves2 == null) {
            if (eCCurves == null) {
                throw new StreamCorruptedException("Cannot determine curve type");
            }
        } else if (eCCurves == null) {
            eCCurves = eCCurves2;
        } else if (eCCurves2 != eCCurves) {
            throw new StreamCorruptedException("Mismatched provide (" + eCCurves + ") vs. parsed curve (" + eCCurves2 + ")");
        }
        BigInteger bigInteger2 = ECCurves.octetStringToInteger(aSN1Object2.getPureValueBytes());
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(bigInteger2, eCCurves.getParameters());
        return new AbstractMap.SimpleImmutableEntry<ECPrivateKeySpec, Object>(eCPrivateKeySpec, (entry == null ? null : (ASN1Object)entry.getValue()));
    }

    public static Map.Entry parseCurveParameter(DERParser dERParser) {
        return ECDSAPEMResourceKeyPairParser.parseCurveParameter(dERParser.readObject());
    }

    public static Map.Entry parseCurveParameter(ASN1Object aSN1Object) {
        List list;
        if (aSN1Object == null) {
            return null;
        }
        ASN1Type aSN1Type = aSN1Object.getObjType();
        if (aSN1Type == ASN1Type.NULL) {
            return null;
        }
        try (Object object = aSN1Object.createParser();){
            ASN1Object aSN1Object2 = ((DERParser)object).readObject();
            if (aSN1Object2 == null) {
                throw new StreamCorruptedException("Missing named curve parameter");
            }
            aSN1Type = aSN1Object2.getObjType();
            if (aSN1Type == ASN1Type.BIT_STRING) {
                AbstractMap.SimpleImmutableEntry<Object, ASN1Object> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Object, ASN1Object>(null, aSN1Object2);
                return simpleImmutableEntry;
            }
            list = aSN1Object2.asOID();
        }
        object = ECCurves.fromOIDValue(list);
        if (object == null) {
            throw new StreamCorruptedException("Unknown curve OID: " + list);
        }
        return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, null);
    }

    public static final ECPoint decodeECPublicKeyValue(DERParser dERParser) {
        return ECDSAPEMResourceKeyPairParser.decodeECPublicKeyValue(dERParser.readObject());
    }

    public static final ECPoint decodeECPublicKeyValue(ASN1Object aSN1Object) {
        if (aSN1Object == null) {
            throw new StreamCorruptedException("No public key data bytes");
        }
        try (DERParser dERParser = aSN1Object.createParser();){
            ECPoint eCPoint = ECDSAPEMResourceKeyPairParser.decodeECPointData(dERParser.readObject());
            return eCPoint;
        }
    }

    public static final ECPoint decodeECPointData(ASN1Object aSN1Object) {
        if (aSN1Object == null) {
            throw new StreamCorruptedException("Missing public key data parameter");
        }
        ASN1Type aSN1Type = aSN1Object.getObjType();
        if (!ASN1Type.BIT_STRING.equals((Object)aSN1Type)) {
            throw new StreamCorruptedException("Non-matching public key object type: " + (Object)((Object)aSN1Type));
        }
        byte[] byArray = aSN1Object.getValue();
        return ECCurves.octetStringToEcPoint(byArray);
    }
}

