/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.pem.AbstractPEMResourceKeyPairParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.security.SecurityUtils;

public class DSSPEMResourceKeyPairParser
extends AbstractPEMResourceKeyPairParser {
    public static final String BEGIN_MARKER = "BEGIN DSA PRIVATE KEY";
    public static final List BEGINNERS = Collections.unmodifiableList(Collections.singletonList("BEGIN DSA PRIVATE KEY"));
    public static final String END_MARKER = "END DSA PRIVATE KEY";
    public static final List ENDERS = Collections.unmodifiableList(Collections.singletonList("END DSA PRIVATE KEY"));
    public static final String DSS_OID = "1.2.840.10040.4.1";
    public static final DSSPEMResourceKeyPairParser INSTANCE = new DSSPEMResourceKeyPairParser();

    public DSSPEMResourceKeyPairParser() {
        super("DSA", DSS_OID, BEGINNERS, ENDERS);
    }

    @Override
    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string, String string2, FilePasswordProvider filePasswordProvider, InputStream inputStream, Map map) {
        KeyPair keyPair = DSSPEMResourceKeyPairParser.decodeDSSKeyPair(SecurityUtils.getKeyFactory("DSA"), inputStream, false);
        return Collections.singletonList(keyPair);
    }

    public static KeyPair decodeDSSKeyPair(KeyFactory keyFactory, InputStream inputStream, boolean bl2) {
        ASN1Object aSN1Object;
        try (DERParser dERParser = new DERParser(NoCloseInputStream.resolveInputStream(inputStream, bl2));){
            aSN1Object = dERParser.readObject();
        }
        if (!ASN1Type.SEQUENCE.equals((Object)aSN1Object.getObjType())) {
            throw new IOException("Invalid DER: not a sequence: " + (Object)((Object)aSN1Object.getObjType()));
        }
        dERParser = aSN1Object.createParser();
        var5_4 = null;
        try {
            ASN1Object aSN1Object2 = dERParser.readObject();
            if (aSN1Object2 == null) {
                throw new StreamCorruptedException("No version");
            }
            BigInteger bigInteger = dERParser.readObject().asInteger();
            BigInteger bigInteger2 = dERParser.readObject().asInteger();
            BigInteger bigInteger3 = dERParser.readObject().asInteger();
            BigInteger bigInteger4 = dERParser.readObject().asInteger();
            BigInteger bigInteger5 = dERParser.readObject().asInteger();
            PublicKey publicKey = keyFactory.generatePublic(new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3));
            PrivateKey privateKey = keyFactory.generatePrivate(new DSAPrivateKeySpec(bigInteger5, bigInteger, bigInteger2, bigInteger3));
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            return keyPair;
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (dERParser != null) {
                if (var5_4 != null) {
                    try {
                        dERParser.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    dERParser.close();
                }
            }
        }
    }
}

