/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.io.ByteArrayInputStream;
import java.io.StreamCorruptedException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.login.CredentialException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.AbstractKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.apache.sshd.common.config.keys.loader.PrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.pem.KeyPairPEMResourceParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public abstract class AbstractPEMResourceKeyPairParser
extends AbstractKeyPairResourceParser
implements KeyPairPEMResourceParser {
    private final String algo;
    private final String algId;

    protected AbstractPEMResourceKeyPairParser(String string, String string2, List list, List list2) {
        super(list, list2);
        this.algo = ValidateUtils.checkNotNullAndNotEmpty(string, "No encryption algorithm provided");
        this.algId = ValidateUtils.checkNotNullAndNotEmpty(string2, "No algorithm identifier provided");
    }

    @Override
    public String getAlgorithm() {
        return this.algo;
    }

    @Override
    public String getAlgorithmIdentifier() {
        return this.algId;
    }

    @Override
    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string, String string2, FilePasswordProvider filePasswordProvider, List list, Map map) {
        Object object;
        Object object2;
        Object object3;
        if (GenericUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        Boolean bl2 = null;
        Object object4 = null;
        String string3 = null;
        int n2 = -1;
        boolean bl3 = MapEntryUtils.isNotEmpty(map);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object3 = GenericUtils.trimToEmpty((String)list.get(i2));
            if (GenericUtils.isEmpty((CharSequence)object3)) continue;
            int n3 = ((String)object3).indexOf(58);
            if (n3 < 0) {
                n2 = i2;
                break;
            }
            object2 = ((String)object3).substring(0, n3).trim();
            object = ((String)object3).substring(n3 + 1).trim();
            if (!bl3) {
                Map map2 = MapEntryUtils.isEmpty(map) ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : map;
                map2.put(object2, object);
            }
            if (((String)object2).equalsIgnoreCase("Proc-Type")) {
                if (bl2 != null) {
                    throw new StreamCorruptedException("Multiple encryption indicators in " + namedResource);
                }
                object = ((String)object).toUpperCase();
                bl2 = ((String)object3).contains("ENCRYPTED");
                continue;
            }
            if (!((String)object2).equalsIgnoreCase("DEK-Info")) continue;
            if (object4 != null || string3 != null) {
                throw new StreamCorruptedException("Multiple encryption settings in " + namedResource);
            }
            int n4 = ((String)object).indexOf(44);
            if (n4 < 0) {
                throw new StreamCorruptedException(namedResource + ": Missing encryption data values separator in line '" + (String)object3 + "'");
            }
            string3 = ((String)object).substring(0, n4).trim();
            String string4 = ((String)object).substring(n4 + 1).trim();
            object4 = BufferUtils.decodeHex('\u0000', string4);
        }
        if (n2 < 0) {
            throw new StreamCorruptedException("No data lines (only headers or empty) found in " + namedResource);
        }
        List list2 = list.subList(n2, list.size());
        if (bl2 != null || string3 != null || object4 != null) {
            if (filePasswordProvider == null) {
                throw new CredentialException("Missing password provider for encrypted resource=" + namedResource);
            }
            String string5 = string3;
            object2 = object4;
            object3 = KeyPairResourceParser.extractDataBytes(list2);
            object = (Collection)filePasswordProvider.decode(sessionContext, namedResource, arg_0 -> this.lambda$extractKeyPairs$0(string5, (byte[])object2, (byte[])object3, sessionContext, namedResource, string, string2, filePasswordProvider, map, arg_0));
            return object == null ? Collections.emptyList() : object;
        }
        return super.extractKeyPairs(sessionContext, namedResource, string, string2, filePasswordProvider, list2, map);
    }

    protected byte[] applyPrivateKeyCipher(byte[] byArray, PrivateKeyEncryptionContext privateKeyEncryptionContext, boolean bl2) {
        byte[] byArray2;
        String string = privateKeyEncryptionContext.getCipherName();
        PrivateKeyObfuscator privateKeyObfuscator = privateKeyEncryptionContext.resolvePrivateKeyObfuscator();
        if (privateKeyObfuscator == null) {
            throw new NoSuchAlgorithmException("decryptPrivateKeyData(" + privateKeyEncryptionContext + ")[encrypt=" + bl2 + "] unknown cipher: " + string);
        }
        if (bl2 && NumberUtils.isEmpty(byArray2 = privateKeyEncryptionContext.getInitVector())) {
            byArray2 = privateKeyObfuscator.generateInitializationVector(privateKeyEncryptionContext);
            privateKeyEncryptionContext.setInitVector(byArray2);
        }
        return privateKeyObfuscator.applyPrivateKeyCipher(byArray, privateKeyEncryptionContext, bl2);
    }

    /*
     * Loose catch block
     */
    private /* synthetic */ Collection lambda$extractKeyPairs$0(String string, byte[] byArray, byte[] byArray2, SessionContext sessionContext, NamedResource namedResource, String string2, String string3, FilePasswordProvider filePasswordProvider, Map map, String string4) {
        PrivateKeyEncryptionContext privateKeyEncryptionContext = new PrivateKeyEncryptionContext(string);
        privateKeyEncryptionContext.setPassword(string4);
        privateKeyEncryptionContext.setInitVector(byArray);
        byte[] byArray3 = GenericUtils.EMPTY_BYTE_ARRAY;
        try {
            byArray3 = this.applyPrivateKeyCipher(byArray2, privateKeyEncryptionContext, false);
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);){
                Collection collection = this.extractKeyPairs(sessionContext, namedResource, string2, string3, filePasswordProvider, byteArrayInputStream, map);
                return collection;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Arrays.fill(byArray3, (byte)0);
        }
    }
}

