/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh.kdf;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.CipherFactory;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKdfOptions;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class RawKdfOptions
implements OpenSSHKdfOptions {
    private String name;
    private byte[] options;

    @Override
    public void initialize(String string, byte[] byArray) {
        this.setName(string);
        this.setOptions(this.options);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public byte[] getOptions() {
        return NumberUtils.emptyIfNull(this.options);
    }

    public void setOptions(byte[] byArray) {
        this.options = NumberUtils.emptyIfNull(byArray);
    }

    @Override
    public boolean isEncrypted() {
        return !IS_NONE_KDF.test(this.getName());
    }

    @Override
    public byte[] decodePrivateKeyBytes(SessionContext sessionContext, NamedResource namedResource, CipherFactory cipherFactory, byte[] byArray, String string) {
        throw new NoSuchAlgorithmException("Unsupported KDF algorithm (" + this.getName() + ")");
    }

    public int hashCode() {
        return GenericUtils.hashCode(this.getName(), Boolean.FALSE) + Arrays.hashCode(this.getOptions());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RawKdfOptions rawKdfOptions = (RawKdfOptions)object;
        return GenericUtils.safeCompare(this.getName(), rawKdfOptions.getName(), false) == 0 && Arrays.equals(this.getOptions(), rawKdfOptions.getOptions());
    }

    public String toString() {
        return this.getName() + ": options=" + BufferUtils.toHex(':', this.getOptions());
    }
}

