/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh.kdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.Cipher$Mode;
import org.apache.sshd.common.cipher.CipherFactory;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKdfOptions;
import org.apache.sshd.common.config.keys.loader.openssh.kdf.BCrypt;
import org.apache.sshd.common.config.keys.loader.openssh.kdf.BCryptKdfOptions$BCryptBadRoundsException;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class BCryptKdfOptions
implements OpenSSHKdfOptions {
    public static final String NAME = "bcrypt";
    public static final int DEFAULT_MAX_ROUNDS = 255;
    private static final AtomicInteger MAX_ROUNDS_HOLDER = new AtomicInteger(255);
    private byte[] salt;
    private int numRounds;

    @Override
    public void initialize(String string, byte[] byArray) {
        if (!NAME.equalsIgnoreCase(string)) {
            throw new StreamCorruptedException("Mismatched KDF name: " + string);
        }
        if (NumberUtils.isEmpty(byArray)) {
            throw new StreamCorruptedException("Missing KDF options for " + string);
        }
        int n2 = byArray.length - 8;
        try (Object object = new ByteArrayInputStream(byArray);){
            this.initialize((InputStream)object, n2);
        }
        object = this.getSalt();
        int n3 = NumberUtils.length((byte[])object);
        if (n3 != n2) {
            throw new StreamCorruptedException("Mismatched salt data length: expected=" + n2 + ", actual=" + n3);
        }
    }

    protected void initialize(InputStream inputStream, int n2) {
        this.setSalt(KeyEntryResolver.readRLEBytes(inputStream, n2));
        this.setNumRounds(KeyEntryResolver.decodeInt(inputStream));
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] decodePrivateKeyBytes(SessionContext sessionContext, NamedResource namedResource, CipherFactory cipherFactory, byte[] byArray, String string) {
        byte[] byArray2;
        int n2;
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        byte[] byArray6;
        byte[] byArray7;
        block24: {
            if (NumberUtils.isEmpty(byArray)) {
                return byArray;
            }
            int n3 = cipherFactory.getCipherBlockSize();
            if (byArray.length % n3 != 0) {
                throw new StreamCorruptedException("Encrypted data size (" + byArray.length + ") is not aligned to  " + cipherFactory.getName() + " block size (" + n3 + ")");
            }
            int n4 = cipherFactory.getKdfSize();
            int n5 = cipherFactory.getIVSize();
            boolean bl2 = "chacha20-poly1305@openssh.com".equals(cipherFactory.getName());
            byArray7 = null;
            byArray6 = null;
            byArray5 = null;
            byArray4 = new byte[bl2 ? n4 : n4 + n5];
            byArray3 = string.getBytes(StandardCharsets.UTF_8);
            this.bcryptKdf(byArray3, byArray4);
            byArray7 = Arrays.copyOf(byArray4, n4);
            byArray6 = new byte[n5];
            if (!bl2) {
                System.arraycopy(byArray4, n4, byArray6, 0, n5);
            }
            Cipher cipher = (Cipher)cipherFactory.create();
            byArray5 = Arrays.copyOf(byArray, byArray.length);
            n2 = cipherFactory.getAuthenticationTagSize();
            cipher.init(Cipher$Mode.Decrypt, byArray7, byArray6);
            cipher.update(byArray5, 0, byArray5.length - n2);
            if (n2 != 0) break block24;
            byte[] byArray8 = byArray5;
            byArray5 = null;
            byte[] byArray9 = byArray8;
            Arrays.fill(byArray3, (byte)0);
            Arrays.fill(byArray4, (byte)0);
            if (byArray7 != null) {
                Arrays.fill(byArray7, (byte)0);
            }
            if (byArray6 != null) {
                Arrays.fill(byArray6, (byte)0);
            }
            if (byArray5 != null) {
                Arrays.fill(byArray5, (byte)0);
            }
            return byArray9;
        }
        try {
            byArray2 = Arrays.copyOf(byArray5, byArray5.length - n2);
        }
        catch (RuntimeException runtimeException) {
            try {
                Throwable throwable = ExceptionUtils.peelException(runtimeException);
                Throwable throwable2 = null;
                if (throwable instanceof IOException || throwable instanceof GeneralSecurityException) {
                    throwable2 = throwable;
                } else {
                    throwable = ExceptionUtils.resolveExceptionCause(runtimeException);
                    if (throwable instanceof IOException || throwable instanceof GeneralSecurityException) {
                        throwable2 = throwable;
                    }
                }
                if (throwable2 instanceof IOException) {
                    throw (IOException)throwable2;
                }
                if (throwable2 instanceof GeneralSecurityException) {
                    throw (GeneralSecurityException)throwable2;
                }
                throw runtimeException;
                catch (IOException | GeneralSecurityException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    throw new GeneralSecurityException(exception);
                }
            }
            catch (Throwable throwable) {
                Arrays.fill(byArray3, (byte)0);
                Arrays.fill(byArray4, (byte)0);
                if (byArray7 != null) {
                    Arrays.fill(byArray7, (byte)0);
                }
                if (byArray6 != null) {
                    Arrays.fill(byArray6, (byte)0);
                }
                if (byArray5 != null) {
                    Arrays.fill(byArray5, (byte)0);
                }
                throw throwable;
            }
        }
        Arrays.fill(byArray3, (byte)0);
        Arrays.fill(byArray4, (byte)0);
        if (byArray7 != null) {
            Arrays.fill(byArray7, (byte)0);
        }
        if (byArray6 != null) {
            Arrays.fill(byArray6, (byte)0);
        }
        if (byArray5 != null) {
            Arrays.fill(byArray5, (byte)0);
        }
        return byArray2;
    }

    protected void bcryptKdf(byte[] byArray, byte[] byArray2) {
        BCrypt bCrypt = new BCrypt();
        bCrypt.pbkdf(byArray, this.getSalt(), this.getNumRounds(), byArray2);
    }

    @Override
    public final String getName() {
        return NAME;
    }

    public byte[] getSalt() {
        return NumberUtils.emptyIfNull(this.salt);
    }

    public void setSalt(byte[] byArray) {
        this.salt = NumberUtils.emptyIfNull(byArray);
    }

    public int getNumRounds() {
        return this.numRounds;
    }

    public void setNumRounds(int n2) {
        int n3 = BCryptKdfOptions.getMaxAllowedRounds();
        if (n2 <= 0 || n2 > n3) {
            throw new BCryptKdfOptions$BCryptBadRoundsException(n2, "Bad rounds value (" + n2 + ") - max. allowed " + n3);
        }
        this.numRounds = n2;
    }

    public int hashCode() {
        return 31 * this.getNumRounds() + Arrays.hashCode(this.getSalt());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BCryptKdfOptions bCryptKdfOptions = (BCryptKdfOptions)object;
        return this.getNumRounds() == bCryptKdfOptions.getNumRounds() && Arrays.equals(this.getSalt(), bCryptKdfOptions.getSalt());
    }

    public String toString() {
        return this.getName() + ": rounds=" + this.getNumRounds() + ", salt=" + BufferUtils.toHex(':', this.getSalt());
    }

    public static int getMaxAllowedRounds() {
        return MAX_ROUNDS_HOLDER.get();
    }

    public static void setMaxAllowedRounds(int n2) {
        ValidateUtils.checkTrue(n2 > 0, "Invalid max. rounds value: %d", n2);
        MAX_ROUNDS_HOLDER.set(n2);
    }
}

