/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh;

import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import org.apache.sshd.common.util.security.SecurityUtils;

public class OpenSSHRSAPrivateKeyDecoder
extends AbstractPrivateKeyEntryDecoder {
    public static final BigInteger DEFAULT_PUBLIC_EXPONENT = KeyUtils.DEFAULT_RSA_PUBLIC_EXPONENT;
    public static final OpenSSHRSAPrivateKeyDecoder INSTANCE = new OpenSSHRSAPrivateKeyDecoder();

    public OpenSSHRSAPrivateKeyDecoder() {
        super(RSAPublicKey.class, RSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-rsa")));
    }

    @Override
    public RSAPrivateKey decodePrivateKey(SessionContext sessionContext, String string, FilePasswordProvider filePasswordProvider, InputStream inputStream) {
        if (!"ssh-rsa".equals(string)) {
            throw new InvalidKeySpecException("Unexpected key type: " + string);
        }
        BigInteger bigInteger = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger2 = KeyEntryResolver.decodeBigInt(inputStream);
        if (!Objects.equals(bigInteger2, DEFAULT_PUBLIC_EXPONENT)) {
            this.log.warn("decodePrivateKey({}) non-standard RSA exponent found: {}", (Object)string, (Object)bigInteger2);
        }
        BigInteger bigInteger3 = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger4 = KeyEntryResolver.decodeBigInt(inputStream);
        Objects.requireNonNull(bigInteger4, "Missing iqmodp");
        BigInteger bigInteger5 = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger6 = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger7 = bigInteger5.multiply(bigInteger6);
        if (!Objects.equals(bigInteger, bigInteger7)) {
            this.log.warn("decodePrivateKey({}) mismatched modulus values: encoded={}, calculated={}", new Object[]{string, bigInteger, bigInteger7});
        }
        return (RSAPrivateKey)this.generatePrivateKey(new RSAPrivateCrtKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger5, bigInteger6, bigInteger3.mod(bigInteger5.subtract(BigInteger.ONE)), bigInteger3.mod(bigInteger6.subtract(BigInteger.ONE)), bigInteger4));
    }

    public String encodePrivateKey(SecureByteArrayOutputStream secureByteArrayOutputStream, RSAPrivateKey rSAPrivateKey, RSAPublicKey rSAPublicKey) {
        Objects.requireNonNull(rSAPrivateKey, "No private key provided");
        if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
            KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, rSAPrivateCrtKey.getModulus());
            KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, rSAPrivateCrtKey.getPublicExponent());
            KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, rSAPrivateCrtKey.getPrivateExponent());
            KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, rSAPrivateCrtKey.getCrtCoefficient());
            KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, rSAPrivateCrtKey.getPrimeP());
            KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, rSAPrivateCrtKey.getPrimeQ());
            return "ssh-rsa";
        }
        return null;
    }

    @Override
    public boolean isPublicKeyRecoverySupported() {
        return true;
    }

    public RSAPublicKey recoverPublicKey(RSAPrivateKey rSAPrivateKey) {
        return KeyUtils.recoverRSAPublicKey(rSAPrivateKey);
    }

    public RSAPublicKey clonePublicKey(RSAPublicKey rSAPublicKey) {
        if (rSAPublicKey == null) {
            return null;
        }
        return (RSAPublicKey)this.generatePublicKey(new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent()));
    }

    public RSAPrivateKey clonePrivateKey(RSAPrivateKey rSAPrivateKey) {
        if (rSAPrivateKey == null) {
            return null;
        }
        if (!(rSAPrivateKey instanceof RSAPrivateCrtKey)) {
            throw new InvalidKeyException("Cannot clone a non-RSAPrivateCrtKey: " + rSAPrivateKey.getClass().getSimpleName());
        }
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
        return (RSAPrivateKey)this.generatePrivateKey(new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        return SecurityUtils.getKeyPairGenerator("RSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        return SecurityUtils.getKeyFactory("RSA");
    }
}

