/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh;

import java.util.function.Predicate;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKdfOptions;
import org.apache.sshd.common.util.GenericUtils;

public class OpenSSHParserContext {
    public static final String NONE_CIPHER = "none";
    public static final Predicate IS_NONE_CIPHER = string -> GenericUtils.isEmpty(string) || NONE_CIPHER.equalsIgnoreCase((String)string);
    private String cipherName;
    private OpenSSHKdfOptions kdfOptions;

    public OpenSSHParserContext() {
    }

    public OpenSSHParserContext(String string, OpenSSHKdfOptions openSSHKdfOptions) {
        this.setCipherName(string);
        this.setKdfOptions(openSSHKdfOptions);
    }

    public boolean isEncrypted() {
        if (!IS_NONE_CIPHER.test(this.getCipherName())) {
            return true;
        }
        OpenSSHKdfOptions openSSHKdfOptions = this.getKdfOptions();
        return openSSHKdfOptions != null && openSSHKdfOptions.isEncrypted();
    }

    public String getCipherName() {
        return this.cipherName;
    }

    public void setCipherName(String string) {
        this.cipherName = string;
    }

    public OpenSSHKdfOptions getKdfOptions() {
        return this.kdfOptions;
    }

    public void setKdfOptions(OpenSSHKdfOptions openSSHKdfOptions) {
        this.kdfOptions = openSSHKdfOptions;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[cipher=" + this.getCipherName() + ", kdfOptions=" + this.getKdfOptions() + "]";
    }
}

