/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.security.auth.login.FailedLoginException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.CipherFactory;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.AbstractKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHDSSPrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHECDSAPrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKdfOptions;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHParserContext;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHRSAPrivateKeyDecoder;
import org.apache.sshd.common.config.keys.loader.openssh.kdf.BCryptKdfOptions;
import org.apache.sshd.common.config.keys.loader.openssh.kdf.RawKdfOptions;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class OpenSSHKeyPairResourceParser
extends AbstractKeyPairResourceParser {
    public static final String BEGIN_MARKER = "BEGIN OPENSSH PRIVATE KEY";
    public static final List BEGINNERS = Collections.unmodifiableList(Collections.singletonList("BEGIN OPENSSH PRIVATE KEY"));
    public static final String END_MARKER = "END OPENSSH PRIVATE KEY";
    public static final List ENDERS = Collections.unmodifiableList(Collections.singletonList("END OPENSSH PRIVATE KEY"));
    public static final String AUTH_MAGIC = "openssh-key-v1";
    public static final OpenSSHKeyPairResourceParser INSTANCE = new OpenSSHKeyPairResourceParser();
    private static final byte[] AUTH_MAGIC_BYTES = "openssh-key-v1".getBytes(StandardCharsets.UTF_8);
    private static final Map BY_KEY_TYPE_DECODERS_MAP = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final Map BY_KEY_CLASS_DECODERS_MAP = new HashMap();

    public OpenSSHKeyPairResourceParser() {
        super(BEGINNERS, ENDERS);
    }

    /*
     * Loose catch block
     */
    @Override
    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string, String string2, FilePasswordProvider filePasswordProvider, InputStream inputStream, Map map) {
        Object object;
        boolean bl2 = this.log.isDebugEnabled();
        inputStream = this.validateStreamMagicMarker(sessionContext, namedResource, inputStream);
        String string3 = KeyEntryResolver.decodeString(inputStream, 256);
        OpenSSHKdfOptions openSSHKdfOptions = this.resolveKdfOptions(sessionContext, namedResource, string, string2, inputStream, map);
        OpenSSHParserContext openSSHParserContext = new OpenSSHParserContext(string3, openSSHKdfOptions);
        int n2 = KeyEntryResolver.decodeInt(inputStream);
        if (n2 <= 0) {
            if (bl2) {
                this.log.debug("extractKeyPairs({}) no encoded keys for context={}", (Object)namedResource, (Object)openSSHParserContext);
            }
            return Collections.emptyList();
        }
        if (bl2) {
            this.log.debug("extractKeyPairs({}) decode {} keys using context={}", new Object[]{namedResource, n2, openSSHParserContext});
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        boolean bl3 = this.log.isTraceEnabled();
        for (int i2 = 1; i2 <= n2; ++i2) {
            object = this.readPublicKey(sessionContext, namedResource, openSSHParserContext, inputStream, map);
            ValidateUtils.checkNotNull(object, "Empty public key #%d in %s", i2, namedResource);
            if (bl3) {
                this.log.trace("extractKeyPairs({}) read public key #{}: {} {}", new Object[]{namedResource, i2, KeyUtils.getKeyType((Key)object), KeyUtils.getFingerPrint((PublicKey)object)});
            }
            arrayList.add(object);
        }
        if (!openSSHParserContext.isEncrypted()) {
            byte[] byArray = KeyEntryResolver.readRLEBytes(inputStream, 262136);
            try {
                object = new ByteArrayInputStream(byArray);
                Throwable throwable = null;
                try {
                    List list = this.readPrivateKeys(sessionContext, namedResource, openSSHParserContext, arrayList, filePasswordProvider, (InputStream)object);
                    return list;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                }
                {
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
            finally {
                Arrays.fill(byArray, (byte)0);
            }
        }
        if (filePasswordProvider == null) {
            throw new FailedLoginException("No password provider for encrypted key in " + namedResource);
        }
        CipherFactory cipherFactory = BuiltinCiphers.resolveFactory(string3);
        if (cipherFactory == null || !cipherFactory.isSupported()) {
            throw new NoSuchAlgorithmException("Unsupported cipher: " + string3 + " for encrypted key in " + namedResource);
        }
        if (cipherFactory.getAuthenticationTagSize() > 0) {
            int n3 = cipherFactory.getAuthenticationTagSize();
            int n4 = KeyEntryResolver.decodeInt(inputStream);
            if (n4 < 0) {
                throw new StreamCorruptedException("Key length " + n4 + " negative for encrypted key in " + namedResource);
            }
            if (n4 > 262136) {
                throw new StreamCorruptedException("Key length " + n4 + " > allowed maximum " + 262136 + " for encrypted key in " + namedResource);
            }
            object = new byte[n4 + n3];
            IoUtils.readFully(inputStream, (byte[])object);
        } else {
            object = KeyEntryResolver.readRLEBytes(inputStream, 262136);
        }
        Collection collection = (Collection)filePasswordProvider.decode(sessionContext, namedResource, arg_0 -> this.lambda$extractKeyPairs$0(openSSHKdfOptions, sessionContext, namedResource, cipherFactory, (byte[])object, openSSHParserContext, arrayList, filePasswordProvider, arg_0));
        return collection == null ? Collections.emptyList() : collection;
    }

    protected OpenSSHKdfOptions resolveKdfOptions(SessionContext sessionContext, NamedResource namedResource, String string, String string2, InputStream inputStream, Map map) {
        String string3 = KeyEntryResolver.decodeString(inputStream, 1024);
        byte[] byArray = KeyEntryResolver.readRLEBytes(inputStream, Short.MAX_VALUE);
        OpenSSHKdfOptions openSSHKdfOptions = "bcrypt".equalsIgnoreCase(string3) ? new BCryptKdfOptions() : new RawKdfOptions();
        openSSHKdfOptions.initialize(string3, byArray);
        return openSSHKdfOptions;
    }

    protected PublicKey readPublicKey(SessionContext sessionContext, NamedResource namedResource, OpenSSHParserContext openSSHParserContext, InputStream inputStream, Map map) {
        byte[] byArray = KeyEntryResolver.readRLEBytes(inputStream, 65534);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            String string = KeyEntryResolver.decodeString(byteArrayInputStream, 256);
            PublicKeyEntryDecoder publicKeyEntryDecoder = KeyUtils.getPublicKeyEntryDecoder(string);
            if (publicKeyEntryDecoder == null) {
                throw new NoSuchAlgorithmException("Unsupported key type (" + string + ") in " + namedResource);
            }
            PublicKey publicKey = publicKeyEntryDecoder.decodePublicKey(sessionContext, string, byteArrayInputStream, map);
            return publicKey;
        }
    }

    protected List readPrivateKeys(SessionContext sessionContext, NamedResource namedResource, OpenSSHParserContext openSSHParserContext, Collection collection, FilePasswordProvider filePasswordProvider, InputStream inputStream) {
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        boolean bl2 = this.log.isTraceEnabled();
        int n2 = KeyEntryResolver.decodeInt(inputStream);
        int n3 = KeyEntryResolver.decodeInt(inputStream);
        if (bl2) {
            this.log.trace("readPrivateKeys({}) check1=0x{}, check2=0x{}", new Object[]{namedResource, Integer.toHexString(n2), Integer.toHexString(n3)});
        }
        if (n2 != n3) {
            throw new StreamCorruptedException("Mismatched private key check values (" + Integer.toHexString(n2) + "/" + Integer.toHexString(n3) + ") in " + namedResource);
        }
        ArrayList<KeyPair> arrayList = new ArrayList<KeyPair>(collection.size());
        for (PublicKey publicKey : collection) {
            Map.Entry entry;
            String string = KeyUtils.getKeyType(publicKey);
            int n4 = arrayList.size() + 1;
            if (bl2) {
                this.log.trace("extractKeyPairs({}) read private key #{}: {}", new Object[]{namedResource, n4, string});
            }
            PrivateKey privateKey = (entry = this.readPrivateKey(sessionContext, namedResource, openSSHParserContext, string, filePasswordProvider, inputStream)) == null ? null : (PrivateKey)entry.getKey();
            ValidateUtils.checkNotNull((Object)privateKey, "Empty private key #%d in %s", n4, namedResource);
            String string2 = KeyUtils.getKeyType(privateKey);
            ValidateUtils.checkTrue(Objects.equals(string, string2), "Mismatched public (%s) vs. private (%s) key type #%d in %s", string, string2, n4, namedResource);
            if (bl2) {
                this.log.trace("extractKeyPairs({}) add private key #{}: {} {}", new Object[]{namedResource, n4, string2, entry.getValue()});
            }
            arrayList.add(new KeyPair(publicKey, privateKey));
        }
        return arrayList;
    }

    protected Map.Entry readPrivateKey(SessionContext sessionContext, NamedResource namedResource, OpenSSHParserContext openSSHParserContext, String string, FilePasswordProvider filePasswordProvider, InputStream inputStream) {
        String string2 = KeyEntryResolver.decodeString(inputStream, 256);
        if (!Objects.equals(string, string2)) {
            throw new StreamCorruptedException("Mismatched private key type: , expected=" + string + ", actual=" + string2 + " in " + namedResource);
        }
        PrivateKeyEntryDecoder privateKeyEntryDecoder = OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(string2);
        if (privateKeyEntryDecoder == null) {
            throw new NoSuchAlgorithmException("Unsupported key type (" + string2 + ") in " + namedResource);
        }
        PrivateKey privateKey = privateKeyEntryDecoder.decodePrivateKey(sessionContext, string2, filePasswordProvider, inputStream);
        if (privateKey == null) {
            throw new InvalidKeyException("Cannot parse key type (" + string2 + ") in " + namedResource);
        }
        String string3 = KeyEntryResolver.decodeString(inputStream, 1024);
        return new AbstractMap.SimpleImmutableEntry<PrivateKey, String>(privateKey, string3);
    }

    protected InputStream validateStreamMagicMarker(SessionContext sessionContext, NamedResource namedResource, InputStream inputStream) {
        byte[] byArray = new byte[AUTH_MAGIC_BYTES.length];
        IoUtils.readFully(inputStream, byArray);
        if (!Arrays.equals(AUTH_MAGIC_BYTES, byArray)) {
            throw new StreamCorruptedException(namedResource + ": Mismatched magic marker value: " + BufferUtils.toHex(':', byArray));
        }
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException(namedResource + ": Premature EOF after magic marker value");
        }
        if (n2 != 0) {
            throw new StreamCorruptedException(namedResource + ": Missing EOS after magic marker value: 0x" + Integer.toHexString(n2));
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPrivateKeyEntryDecoder(PrivateKeyEntryDecoder privateKeyEntryDecoder) {
        Objects.requireNonNull(privateKeyEntryDecoder, "No decoder specified");
        Class clazz = Objects.requireNonNull(privateKeyEntryDecoder.getPublicKeyType(), "No public key type declared");
        Class clazz2 = Objects.requireNonNull(privateKeyEntryDecoder.getPrivateKeyType(), "No private key type declared");
        Object object = BY_KEY_CLASS_DECODERS_MAP;
        synchronized (object) {
            BY_KEY_CLASS_DECODERS_MAP.put(clazz, privateKeyEntryDecoder);
            BY_KEY_CLASS_DECODERS_MAP.put(clazz2, privateKeyEntryDecoder);
        }
        object = ValidateUtils.checkNotNullAndNotEmpty(privateKeyEntryDecoder.getSupportedKeyTypes(), "No supported key type", new Object[0]);
        Map map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                PrivateKeyEntryDecoder privateKeyEntryDecoder2 = BY_KEY_TYPE_DECODERS_MAP.put(string, privateKeyEntryDecoder);
                if (privateKeyEntryDecoder2 == null) continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKeyEntryDecoder getPrivateKeyEntryDecoder(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        Map map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            return (PrivateKeyEntryDecoder)BY_KEY_TYPE_DECODERS_MAP.get(string);
        }
    }

    public static PrivateKeyEntryDecoder getPrivateKeyEntryDecoder(KeyPair keyPair) {
        PrivateKeyEntryDecoder privateKeyEntryDecoder;
        if (keyPair == null) {
            return null;
        }
        PrivateKeyEntryDecoder privateKeyEntryDecoder2 = OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(keyPair.getPublic());
        if (privateKeyEntryDecoder2 == (privateKeyEntryDecoder = OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(keyPair.getPrivate()))) {
            return privateKeyEntryDecoder2;
        }
        return null;
    }

    public static PrivateKeyEntryDecoder getPrivateKeyEntryDecoder(Key key) {
        if (key == null) {
            return null;
        }
        return OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(key.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKeyEntryDecoder getPrivateKeyEntryDecoder(Class clazz) {
        if (clazz == null || !Key.class.isAssignableFrom(clazz)) {
            return null;
        }
        Map map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            PrivateKeyEntryDecoder privateKeyEntryDecoder = (PrivateKeyEntryDecoder)BY_KEY_CLASS_DECODERS_MAP.get(clazz);
            if (privateKeyEntryDecoder != null) {
                return privateKeyEntryDecoder;
            }
            for (PrivateKeyEntryDecoder privateKeyEntryDecoder2 : BY_KEY_CLASS_DECODERS_MAP.values()) {
                Class clazz2 = privateKeyEntryDecoder2.getPublicKeyType();
                Class clazz3 = privateKeyEntryDecoder2.getPrivateKeyType();
                if (!clazz2.isAssignableFrom(clazz) && !clazz3.isAssignableFrom(clazz)) continue;
                return privateKeyEntryDecoder2;
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private /* synthetic */ List lambda$extractKeyPairs$0(OpenSSHKdfOptions openSSHKdfOptions, SessionContext sessionContext, NamedResource namedResource, CipherFactory cipherFactory, byte[] byArray, OpenSSHParserContext openSSHParserContext, List list, FilePasswordProvider filePasswordProvider, String string) {
        byte[] byArray2 = openSSHKdfOptions.decodePrivateKeyBytes(sessionContext, namedResource, cipherFactory, byArray, string);
        try {
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);){
                List list2 = this.readPrivateKeys(sessionContext, namedResource, openSSHParserContext, list, filePasswordProvider, byteArrayInputStream);
                return list2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Arrays.fill(byArray2, (byte)0);
        }
    }

    static {
        OpenSSHKeyPairResourceParser.registerPrivateKeyEntryDecoder(OpenSSHRSAPrivateKeyDecoder.INSTANCE);
        OpenSSHKeyPairResourceParser.registerPrivateKeyEntryDecoder(OpenSSHDSSPrivateKeyEntryDecoder.INSTANCE);
        if (SecurityUtils.isECCSupported()) {
            OpenSSHKeyPairResourceParser.registerPrivateKeyEntryDecoder(OpenSSHECDSAPrivateKeyEntryDecoder.INSTANCE);
        }
        if (SecurityUtils.isEDDSACurveSupported()) {
            OpenSSHKeyPairResourceParser.registerPrivateKeyEntryDecoder(SecurityUtils.getOpenSSHEDDSAPrivateKeyEntryDecoder());
        }
    }
}

