/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh;

import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.cipher.ECCurves$ECPointCompression;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import org.apache.sshd.common.util.security.SecurityUtils;

public class OpenSSHECDSAPrivateKeyEntryDecoder
extends AbstractPrivateKeyEntryDecoder {
    public static final OpenSSHECDSAPrivateKeyEntryDecoder INSTANCE = new OpenSSHECDSAPrivateKeyEntryDecoder();

    public OpenSSHECDSAPrivateKeyEntryDecoder() {
        super(ECPublicKey.class, ECPrivateKey.class, ECCurves.KEY_TYPES);
    }

    @Override
    public ECPrivateKey decodePrivateKey(SessionContext sessionContext, String string, FilePasswordProvider filePasswordProvider, InputStream inputStream) {
        String string2;
        ECCurves eCCurves = ECCurves.fromKeyType(string);
        if (eCCurves == null) {
            throw new InvalidKeySpecException("Not an EC curve name: " + string);
        }
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        String string3 = eCCurves.getName();
        if (!string3.equals(string2 = KeyEntryResolver.decodeString(inputStream, 1024))) {
            throw new InvalidKeySpecException("Mismatched key curve name (" + string3 + ") vs. encoded one (" + string2 + ")");
        }
        byte[] byArray = KeyEntryResolver.readRLEBytes(inputStream, Short.MAX_VALUE);
        Objects.requireNonNull(byArray, "No public point");
        BigInteger bigInteger = KeyEntryResolver.decodeBigInt(inputStream);
        ECParameterSpec eCParameterSpec = eCCurves.getParameters();
        return (ECPrivateKey)this.generatePrivateKey(new ECPrivateKeySpec(bigInteger, eCParameterSpec));
    }

    public String encodePrivateKey(SecureByteArrayOutputStream secureByteArrayOutputStream, ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) {
        Objects.requireNonNull(eCPrivateKey, "No private key provided");
        Objects.requireNonNull(eCPublicKey, "No public key provided");
        ECCurves eCCurves = ECCurves.fromECKey(eCPrivateKey);
        if (eCCurves == null) {
            return null;
        }
        String string = eCCurves.getName();
        KeyEntryResolver.encodeString(secureByteArrayOutputStream, string);
        ECCurves$ECPointCompression.UNCOMPRESSED.writeECPoint(secureByteArrayOutputStream, string, eCPublicKey.getW());
        KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, eCPrivateKey.getS());
        return eCCurves.getKeyType();
    }

    public ECPublicKey recoverPublicKey(ECPrivateKey eCPrivateKey) {
        ECCurves eCCurves = ECCurves.fromECKey(eCPrivateKey);
        if (eCCurves == null) {
            throw new InvalidKeyException("Unknown curve");
        }
        return (ECPublicKey)super.recoverPublicKey(eCPrivateKey);
    }

    public ECPublicKey clonePublicKey(ECPublicKey eCPublicKey) {
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        if (eCPublicKey == null) {
            return null;
        }
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        if (eCParameterSpec == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (ECPublicKey)this.generatePublicKey(new ECPublicKeySpec(eCPublicKey.getW(), eCParameterSpec));
    }

    public ECPrivateKey clonePrivateKey(ECPrivateKey eCPrivateKey) {
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        if (eCPrivateKey == null) {
            return null;
        }
        ECParameterSpec eCParameterSpec = eCPrivateKey.getParams();
        if (eCParameterSpec == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (ECPrivateKey)this.generatePrivateKey(new ECPrivateKeySpec(eCPrivateKey.getS(), eCParameterSpec));
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        if (SecurityUtils.isECCSupported()) {
            return SecurityUtils.getKeyFactory("EC");
        }
        throw new NoSuchProviderException("ECC not supported");
    }

    @Override
    public KeyPair generateKeyPair(int n2) {
        ECCurves eCCurves = ECCurves.fromCurveSize(n2);
        if (eCCurves == null) {
            throw new InvalidKeySpecException("Unknown curve for key size=" + n2);
        }
        KeyPairGenerator keyPairGenerator = this.getKeyPairGenerator();
        keyPairGenerator.initialize(eCCurves.getParameters());
        return keyPairGenerator.generateKeyPair();
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        if (SecurityUtils.isECCSupported()) {
            return SecurityUtils.getKeyPairGenerator("EC");
        }
        throw new NoSuchProviderException("ECC not supported");
    }
}

