/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh;

import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import org.apache.sshd.common.util.security.SecurityUtils;

public class OpenSSHDSSPrivateKeyEntryDecoder
extends AbstractPrivateKeyEntryDecoder {
    public static final OpenSSHDSSPrivateKeyEntryDecoder INSTANCE = new OpenSSHDSSPrivateKeyEntryDecoder();

    public OpenSSHDSSPrivateKeyEntryDecoder() {
        super(DSAPublicKey.class, DSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-dss")));
    }

    @Override
    public DSAPrivateKey decodePrivateKey(SessionContext sessionContext, String string, FilePasswordProvider filePasswordProvider, InputStream inputStream) {
        if (!"ssh-dss".equals(string)) {
            throw new InvalidKeySpecException("Unexpected key type: " + string);
        }
        BigInteger bigInteger = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger2 = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger3 = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger4 = KeyEntryResolver.decodeBigInt(inputStream);
        Objects.requireNonNull(bigInteger4, "No public key data");
        BigInteger bigInteger5 = KeyEntryResolver.decodeBigInt(inputStream);
        return (DSAPrivateKey)this.generatePrivateKey(new DSAPrivateKeySpec(bigInteger5, bigInteger, bigInteger2, bigInteger3));
    }

    public String encodePrivateKey(SecureByteArrayOutputStream secureByteArrayOutputStream, DSAPrivateKey dSAPrivateKey, DSAPublicKey dSAPublicKey) {
        Objects.requireNonNull(dSAPrivateKey, "No private key provided");
        DSAParams dSAParams = Objects.requireNonNull(dSAPrivateKey.getParams(), "No DSA params available");
        BigInteger bigInteger = dSAParams.getP();
        KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, bigInteger);
        KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, dSAParams.getQ());
        BigInteger bigInteger2 = dSAParams.getG();
        KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, bigInteger2);
        BigInteger bigInteger3 = dSAPrivateKey.getX();
        BigInteger bigInteger4 = dSAPublicKey != null ? dSAPublicKey.getY() : bigInteger2.modPow(bigInteger3, bigInteger);
        KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, bigInteger4);
        KeyEntryResolver.encodeBigInt(secureByteArrayOutputStream, bigInteger3);
        return "ssh-dss";
    }

    @Override
    public boolean isPublicKeyRecoverySupported() {
        return true;
    }

    public DSAPublicKey recoverPublicKey(DSAPrivateKey dSAPrivateKey) {
        return KeyUtils.recoverDSAPublicKey(dSAPrivateKey);
    }

    public DSAPublicKey clonePublicKey(DSAPublicKey dSAPublicKey) {
        if (dSAPublicKey == null) {
            return null;
        }
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (dSAParams == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (DSAPublicKey)this.generatePublicKey(new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG()));
    }

    public DSAPrivateKey clonePrivateKey(DSAPrivateKey dSAPrivateKey) {
        if (dSAPrivateKey == null) {
            return null;
        }
        DSAParams dSAParams = dSAPrivateKey.getParams();
        if (dSAParams == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (DSAPrivateKey)this.generatePrivateKey(new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        return SecurityUtils.getKeyPairGenerator("DSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        return SecurityUtils.getKeyFactory("DSA");
    }
}

