/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sshd.common.auth.MutablePassword;
import org.apache.sshd.common.config.keys.loader.AESPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.AbstractPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.DESPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.PrivateKeyObfuscator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class PrivateKeyEncryptionContext
implements Cloneable,
MutablePassword {
    public static final String DEFAULT_CIPHER_MODE = "CBC";
    private static final Map OBFUSCATORS = Stream.of(AESPrivateKeyObfuscator.INSTANCE, DESPrivateKeyObfuscator.INSTANCE).collect(Collectors.toMap(AbstractPrivateKeyObfuscator::getCipherName, Function.identity(), MapEntryUtils.throwingMerger(), () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
    private String cipherName;
    private String cipherType;
    private String cipherMode = "CBC";
    private String password;
    private byte[] initVector;
    private transient PrivateKeyObfuscator obfuscator;

    public PrivateKeyEncryptionContext() {
    }

    public PrivateKeyEncryptionContext(String string) {
        this.parseAlgorithmInfo(string);
    }

    public String getCipherName() {
        return this.cipherName;
    }

    public void setCipherName(String string) {
        this.cipherName = string;
    }

    public String getCipherType() {
        return this.cipherType;
    }

    public void setCipherType(String string) {
        this.cipherType = string;
    }

    public String getCipherMode() {
        return this.cipherMode;
    }

    public void setCipherMode(String string) {
        this.cipherMode = string;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
    }

    public byte[] getInitVector() {
        return this.initVector;
    }

    public void setInitVector(byte ... byArray) {
        this.initVector = byArray;
    }

    public PrivateKeyObfuscator getPrivateKeyObfuscator() {
        return this.obfuscator;
    }

    public void setPrivateKeyObfuscator(PrivateKeyObfuscator privateKeyObfuscator) {
        this.obfuscator = privateKeyObfuscator;
    }

    public PrivateKeyObfuscator resolvePrivateKeyObfuscator() {
        PrivateKeyObfuscator privateKeyObfuscator = this.getPrivateKeyObfuscator();
        if (privateKeyObfuscator != null) {
            return privateKeyObfuscator;
        }
        return PrivateKeyEncryptionContext.getRegisteredPrivateKeyObfuscator(this.getCipherName());
    }

    public static PrivateKeyObfuscator registerPrivateKeyObfuscator(PrivateKeyObfuscator privateKeyObfuscator) {
        return PrivateKeyEncryptionContext.registerPrivateKeyObfuscator(Objects.requireNonNull(privateKeyObfuscator, "No instance provided").getCipherName(), privateKeyObfuscator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKeyObfuscator registerPrivateKeyObfuscator(String string, PrivateKeyObfuscator privateKeyObfuscator) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No cipher name");
        Objects.requireNonNull(privateKeyObfuscator, "No instance provided");
        Map map = OBFUSCATORS;
        synchronized (map) {
            return OBFUSCATORS.put(string, privateKeyObfuscator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterPrivateKeyObfuscator(PrivateKeyObfuscator privateKeyObfuscator) {
        Objects.requireNonNull(privateKeyObfuscator, "No instance provided");
        String string = privateKeyObfuscator.getCipherName();
        ValidateUtils.checkNotNullAndNotEmpty(string, "No cipher name");
        Map map = OBFUSCATORS;
        synchronized (map) {
            PrivateKeyObfuscator privateKeyObfuscator2 = (PrivateKeyObfuscator)OBFUSCATORS.get(string);
            if (privateKeyObfuscator2 != privateKeyObfuscator) {
                return false;
            }
            OBFUSCATORS.remove(string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKeyObfuscator unregisterPrivateKeyObfuscator(String string) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No cipher name");
        Map map = OBFUSCATORS;
        synchronized (map) {
            return (PrivateKeyObfuscator)OBFUSCATORS.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PrivateKeyObfuscator getRegisteredPrivateKeyObfuscator(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        Map map = OBFUSCATORS;
        synchronized (map) {
            return (PrivateKeyObfuscator)OBFUSCATORS.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NavigableSet getRegisteredPrivateKeyObfuscatorCiphers() {
        Map map = OBFUSCATORS;
        synchronized (map) {
            Set set = OBFUSCATORS.keySet();
            return GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getRegisteredPrivateKeyObfuscators() {
        Map map = OBFUSCATORS;
        synchronized (map) {
            Collection collection = OBFUSCATORS.values();
            if (GenericUtils.isEmpty(collection)) {
                return Collections.emptyList();
            }
            return new ArrayList(collection);
        }
    }

    public PrivateKeyEncryptionContext parseAlgorithmInfo(String string) {
        return PrivateKeyEncryptionContext.parseAlgorithmInfo(this, string);
    }

    public PrivateKeyEncryptionContext clone() {
        try {
            PrivateKeyEncryptionContext privateKeyEncryptionContext = (PrivateKeyEncryptionContext)this.getClass().cast(super.clone());
            byte[] byArray = privateKeyEncryptionContext.getInitVector();
            if (byArray != null) {
                byArray = (byte[])byArray.clone();
                privateKeyEncryptionContext.setInitVector(byArray);
            }
            return privateKeyEncryptionContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException("Failed to clone: " + this.toString());
        }
    }

    public int hashCode() {
        return GenericUtils.hashCode(this.getCipherName(), Boolean.TRUE) + GenericUtils.hashCode(this.getCipherType(), Boolean.TRUE) + GenericUtils.hashCode(this.getCipherMode(), Boolean.TRUE) + Objects.hashCode(this.getPassword()) + Arrays.hashCode(this.getInitVector());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PrivateKeyEncryptionContext privateKeyEncryptionContext = (PrivateKeyEncryptionContext)object;
        return GenericUtils.safeCompare(this.getCipherName(), privateKeyEncryptionContext.getCipherName(), false) == 0 && GenericUtils.safeCompare(this.getCipherType(), privateKeyEncryptionContext.getCipherType(), false) == 0 && GenericUtils.safeCompare(this.getCipherMode(), privateKeyEncryptionContext.getCipherMode(), false) == 0 && GenericUtils.safeCompare(this.getPassword(), privateKeyEncryptionContext.getPassword(), true) == 0 && Arrays.equals(this.getInitVector(), privateKeyEncryptionContext.getInitVector());
    }

    public String toString() {
        return GenericUtils.join((Object[])new String[]{this.getCipherName(), this.getCipherType(), this.getCipherMode()}, '-');
    }

    public static final PrivateKeyEncryptionContext parseAlgorithmInfo(PrivateKeyEncryptionContext privateKeyEncryptionContext, String string) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No encryption algorithm data");
        String[] stringArray = GenericUtils.split(string, '-');
        ValidateUtils.checkTrue(stringArray.length == 3, "Bad encryption algorithm data: %s", (Object)string);
        privateKeyEncryptionContext.setCipherName(stringArray[0]);
        privateKeyEncryptionContext.setCipherType(stringArray[1]);
        privateKeyEncryptionContext.setCipherMode(stringArray[2]);
        return privateKeyEncryptionContext;
    }

    public static final PrivateKeyEncryptionContext newPrivateKeyEncryptionContext(PrivateKeyObfuscator privateKeyObfuscator, String string) {
        return PrivateKeyEncryptionContext.initializeObfuscator(new PrivateKeyEncryptionContext(), privateKeyObfuscator, string);
    }

    public static final PrivateKeyEncryptionContext initializeObfuscator(PrivateKeyEncryptionContext privateKeyEncryptionContext, PrivateKeyObfuscator privateKeyObfuscator, String string) {
        privateKeyEncryptionContext.setCipherName(privateKeyObfuscator.getCipherName());
        privateKeyEncryptionContext.setPrivateKeyObfuscator(privateKeyObfuscator);
        privateKeyEncryptionContext.setPassword(string);
        return privateKeyEncryptionContext;
    }
}

