/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceLoader;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser$1;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser$2;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface KeyPairResourceParser
extends KeyPairResourceLoader {
    public static final KeyPairResourceParser EMPTY = new KeyPairResourceParser$1();

    public boolean canExtractKeyPairs(NamedResource var1, List var2);

    public static byte[] extractDataBytes(Collection collection) {
        String string = KeyPairResourceParser.joinDataLines(collection);
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(string);
    }

    public static String joinDataLines(Collection collection) {
        String string = GenericUtils.join((Iterable)collection, ' ');
        string = string.replaceAll("\\s", "");
        string = string.trim();
        return string;
    }

    public static boolean containsMarkerLine(List list, String string) {
        return KeyPairResourceParser.containsMarkerLine(list, Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty(string, "No marker")));
    }

    public static boolean containsMarkerLine(List list, List list2) {
        return KeyPairResourceParser.findMarkerLine(list, list2) != null;
    }

    public static AbstractMap.SimpleImmutableEntry findMarkerLine(List list, List list2) {
        return KeyPairResourceParser.findMarkerLine(list, 0, list2);
    }

    public static AbstractMap.SimpleImmutableEntry findMarkerLine(List list, int n2, List list2) {
        if (GenericUtils.isEmpty(list) || GenericUtils.isEmpty(list2)) {
            return null;
        }
        for (int i2 = n2; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                String string2 = (String)list2.get(i3);
                if (!string.contains(string2)) continue;
                return new AbstractMap.SimpleImmutableEntry<Integer, Integer>(i2, i3);
            }
        }
        return null;
    }

    public static KeyPairResourceParser aggregate(KeyPairResourceParser ... keyPairResourceParserArray) {
        return KeyPairResourceParser.aggregate(Arrays.asList(ValidateUtils.checkNotNullAndNotEmpty(keyPairResourceParserArray, "No parsers to aggregate", new Object[0])));
    }

    public static KeyPairResourceParser aggregate(Collection collection) {
        ValidateUtils.checkNotNullAndNotEmpty(collection, "No parsers to aggregate", new Object[0]);
        return new KeyPairResourceParser$2(collection);
    }
}

