/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.io.resource.URLResource;

@FunctionalInterface
public interface KeyPairResourceLoader {
    public static final int MAX_CIPHER_NAME_LENGTH = 256;
    public static final int MAX_KEY_TYPE_NAME_LENGTH = 256;
    public static final int MAX_KEY_COMMENT_LENGTH = 1024;
    public static final int MAX_PUBLIC_KEY_DATA_SIZE = 65534;
    public static final int MAX_PRIVATE_KEY_DATA_SIZE = 262136;
    public static final KeyPairResourceLoader EMPTY = (sessionContext, namedResource, filePasswordProvider, list) -> Collections.emptyList();

    default public Collection loadKeyPairs(SessionContext sessionContext, Path path, FilePasswordProvider filePasswordProvider, OpenOption ... openOptionArray) {
        return this.loadKeyPairs(sessionContext, path, filePasswordProvider, StandardCharsets.UTF_8, openOptionArray);
    }

    default public Collection loadKeyPairs(SessionContext sessionContext, Path path, FilePasswordProvider filePasswordProvider, Charset charset, OpenOption ... openOptionArray) {
        return this.loadKeyPairs(sessionContext, new PathResource(path, openOptionArray), filePasswordProvider, charset);
    }

    default public Collection loadKeyPairs(SessionContext sessionContext, URL uRL, FilePasswordProvider filePasswordProvider) {
        return this.loadKeyPairs(sessionContext, uRL, filePasswordProvider, StandardCharsets.UTF_8);
    }

    default public Collection loadKeyPairs(SessionContext sessionContext, URL uRL, FilePasswordProvider filePasswordProvider, Charset charset) {
        return this.loadKeyPairs(sessionContext, new URLResource(uRL), filePasswordProvider, charset);
    }

    default public Collection loadKeyPairs(SessionContext sessionContext, IoResource ioResource, FilePasswordProvider filePasswordProvider) {
        return this.loadKeyPairs(sessionContext, ioResource, filePasswordProvider, StandardCharsets.UTF_8);
    }

    default public Collection loadKeyPairs(SessionContext sessionContext, IoResource ioResource, FilePasswordProvider filePasswordProvider, Charset charset) {
        try (InputStream inputStream = Objects.requireNonNull(ioResource, "No resource data").openInputStream();){
            Collection collection = this.loadKeyPairs(sessionContext, ioResource, filePasswordProvider, inputStream, charset);
            return collection;
        }
    }

    default public Collection loadKeyPairs(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider filePasswordProvider, String string) {
        try (StringReader stringReader = new StringReader(string == null ? "" : string);){
            Collection collection = this.loadKeyPairs(sessionContext, namedResource, filePasswordProvider, stringReader);
            return collection;
        }
    }

    default public Collection loadKeyPairs(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider filePasswordProvider, InputStream inputStream) {
        return this.loadKeyPairs(sessionContext, namedResource, filePasswordProvider, inputStream, StandardCharsets.UTF_8);
    }

    default public Collection loadKeyPairs(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider filePasswordProvider, InputStream inputStream, Charset charset) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream, "No stream instance"), Objects.requireNonNull(charset, "No charset"));){
            Collection collection = this.loadKeyPairs(sessionContext, namedResource, filePasswordProvider, inputStreamReader);
            return collection;
        }
    }

    default public Collection loadKeyPairs(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider filePasswordProvider, Reader reader) {
        try (BufferedReader bufferedReader = new BufferedReader(Objects.requireNonNull(reader, "No reader instance"), 8192);){
            Collection collection = this.loadKeyPairs(sessionContext, namedResource, filePasswordProvider, bufferedReader);
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Collection loadKeyPairs(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider filePasswordProvider, BufferedReader bufferedReader) {
        List list = IoUtils.readAllLines(bufferedReader);
        try {
            Collection collection = this.loadKeyPairs(sessionContext, namedResource, filePasswordProvider, list);
            return collection;
        }
        finally {
            list.clear();
        }
    }

    public Collection loadKeyPairs(SessionContext var1, NamedResource var2, FilePasswordProvider var3, List var4);
}

