/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceLoader;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.io.resource.PathResource;

public class FileWatcherKeyPairResourceLoader
extends ModifiableFileWatcher
implements KeyPairResourceLoader {
    protected final AtomicReference keysHolder = new AtomicReference(Collections.emptyList());
    private KeyPairResourceLoader delegateLoader;

    public FileWatcherKeyPairResourceLoader(Path path, KeyPairResourceLoader keyPairResourceLoader) {
        this(path, keyPairResourceLoader, IoUtils.getLinkOptions(true));
    }

    public FileWatcherKeyPairResourceLoader(Path path, KeyPairResourceLoader keyPairResourceLoader, LinkOption ... linkOptionArray) {
        super(path, linkOptionArray);
        this.delegateLoader = Objects.requireNonNull(keyPairResourceLoader, "No delegate loader provided");
    }

    public KeyPairResourceLoader getKeyPairResourceLoader() {
        return this.delegateLoader;
    }

    public void setKeyPairResourceLoader(KeyPairResourceLoader keyPairResourceLoader) {
        this.delegateLoader = Objects.requireNonNull(keyPairResourceLoader, "No delegate loader provided");
    }

    @Override
    public Collection loadKeyPairs(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider filePasswordProvider, List list) {
        Collection collection = (Collection)this.keysHolder.get();
        if (GenericUtils.isEmpty(collection) || this.checkReloadRequired()) {
            this.keysHolder.set(Collections.emptyList());
            if (!this.exists()) {
                return (Collection)this.keysHolder.get();
            }
            Path path = this.getPath();
            collection = this.reloadKeyPairs(sessionContext, new PathResource(path), filePasswordProvider, list);
            int n2 = GenericUtils.size(collection);
            if (this.log.isDebugEnabled()) {
                this.log.debug("loadKeyPairs({})[{}] reloaded {} keys from {}", new Object[]{sessionContext, namedResource, n2, path});
            }
            if (n2 > 0) {
                this.keysHolder.set(collection);
                this.updateReloadAttributes();
            }
        }
        return collection;
    }

    protected Collection reloadKeyPairs(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider filePasswordProvider, List list) {
        KeyPairResourceLoader keyPairResourceLoader = (KeyPairResourceLoader)ValidateUtils.checkNotNull((Object)this.getKeyPairResourceLoader(), "No resource loader for %s", (Object)namedResource.getName());
        return keyPairResourceLoader.loadKeyPairs(sessionContext, namedResource, filePasswordProvider, list);
    }
}

