/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.config.keys.loader.AbstractPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;

public class DESPrivateKeyObfuscator
extends AbstractPrivateKeyObfuscator {
    public static final int DEFAULT_KEY_LENGTH = 24;
    public static final List AVAILABLE_KEY_LENGTHS = Collections.unmodifiableList(Collections.singletonList(24));
    public static final DESPrivateKeyObfuscator INSTANCE = new DESPrivateKeyObfuscator();

    public DESPrivateKeyObfuscator() {
        super("DES");
    }

    @Override
    public byte[] applyPrivateKeyCipher(byte[] byArray, PrivateKeyEncryptionContext privateKeyEncryptionContext, boolean bl2) {
        PrivateKeyEncryptionContext privateKeyEncryptionContext2 = DESPrivateKeyObfuscator.resolveEffectiveContext(privateKeyEncryptionContext);
        byte[] byArray2 = this.deriveEncryptionKey(privateKeyEncryptionContext2, 24);
        return this.applyPrivateKeyCipher(byArray, privateKeyEncryptionContext2, byArray2.length * 8, byArray2, bl2);
    }

    @Override
    public List getSupportedKeySizes() {
        return AVAILABLE_KEY_LENGTHS;
    }

    @Override
    protected int resolveKeyLength(PrivateKeyEncryptionContext privateKeyEncryptionContext) {
        return 24;
    }

    @Override
    protected int resolveInitializationVectorLength(PrivateKeyEncryptionContext privateKeyEncryptionContext) {
        return 8;
    }

    public static final PrivateKeyEncryptionContext resolveEffectiveContext(PrivateKeyEncryptionContext privateKeyEncryptionContext) {
        if (privateKeyEncryptionContext == null) {
            return null;
        }
        String string = privateKeyEncryptionContext.getCipherName();
        String string2 = privateKeyEncryptionContext.getCipherType();
        PrivateKeyEncryptionContext privateKeyEncryptionContext2 = privateKeyEncryptionContext;
        if ("EDE3".equalsIgnoreCase(string2)) {
            string = string + "ede";
            privateKeyEncryptionContext2 = privateKeyEncryptionContext.clone();
            privateKeyEncryptionContext2.setCipherName(string);
        }
        return privateKeyEncryptionContext2;
    }
}

