/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.apache.sshd.common.config.keys.loader.PrivateKeyObfuscator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractPrivateKeyObfuscator
implements PrivateKeyObfuscator {
    private final String algName;

    protected AbstractPrivateKeyObfuscator(String string) {
        this.algName = ValidateUtils.checkNotNullAndNotEmpty(string, "No name specified");
    }

    @Override
    public final String getCipherName() {
        return this.algName;
    }

    @Override
    public byte[] generateInitializationVector(PrivateKeyEncryptionContext privateKeyEncryptionContext) {
        int n2 = this.resolveInitializationVectorLength(privateKeyEncryptionContext);
        byte[] byArray = new byte[n2];
        SecureRandom secureRandom = new SecureRandom();
        ((Random)secureRandom).nextBytes(byArray);
        return byArray;
    }

    @Override
    public Appendable appendPrivateKeyEncryptionContext(Appendable appendable, PrivateKeyEncryptionContext privateKeyEncryptionContext) {
        if (privateKeyEncryptionContext == null) {
            return appendable;
        }
        appendable.append("DEK-Info: ").append(privateKeyEncryptionContext.getCipherName()).append('-').append(privateKeyEncryptionContext.getCipherType()).append('-').append(privateKeyEncryptionContext.getCipherMode());
        byte[] byArray = privateKeyEncryptionContext.getInitVector();
        Objects.requireNonNull(byArray, "No encryption init vector");
        ValidateUtils.checkTrue(byArray.length > 0, "Empty encryption init vector");
        BufferUtils.appendHex(appendable.append(','), '\u0000', byArray);
        appendable.append(System.lineSeparator());
        return appendable;
    }

    protected abstract int resolveInitializationVectorLength(PrivateKeyEncryptionContext var1);

    protected abstract int resolveKeyLength(PrivateKeyEncryptionContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] deriveEncryptionKey(PrivateKeyEncryptionContext privateKeyEncryptionContext, int n2) {
        Objects.requireNonNull(privateKeyEncryptionContext, "No encryption context");
        ValidateUtils.checkNotNullAndNotEmpty(privateKeyEncryptionContext.getCipherName(), "No cipher name");
        ValidateUtils.checkNotNullAndNotEmpty(privateKeyEncryptionContext.getCipherType(), "No cipher type");
        ValidateUtils.checkNotNullAndNotEmpty(privateKeyEncryptionContext.getCipherMode(), "No cipher mode");
        byte[] byArray = Objects.requireNonNull(privateKeyEncryptionContext.getInitVector(), "No encryption init vector");
        ValidateUtils.checkTrue(byArray.length > 0, "Empty encryption init vector");
        String string = ValidateUtils.checkNotNullAndNotEmpty(privateKeyEncryptionContext.getPassword(), "No encryption password");
        byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray3 = GenericUtils.EMPTY_BYTE_ARRAY;
        try {
            byte[] byArray4 = new byte[n2];
            MessageDigest messageDigest = SecurityUtils.getMessageDigest("md5");
            int n3 = 0;
            int n4 = byArray4.length;
            while (n3 < byArray4.length) {
                messageDigest.reset();
                messageDigest.update(byArray3, 0, byArray3.length);
                messageDigest.update(byArray2, 0, byArray2.length);
                messageDigest.update(byArray, 0, Math.min(byArray.length, 8));
                byArray3 = messageDigest.digest();
                System.arraycopy(byArray3, 0, byArray4, n3, Math.min(n4, byArray3.length));
                n3 += byArray3.length;
                n4 -= byArray3.length;
            }
            byte[] byArray5 = byArray4;
            return byArray5;
        }
        finally {
            string = null;
            Arrays.fill(byArray2, (byte)0);
            Arrays.fill(byArray3, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] applyPrivateKeyCipher(byte[] byArray, PrivateKeyEncryptionContext privateKeyEncryptionContext, int n2, byte[] byArray2, boolean bl2) {
        Objects.requireNonNull(privateKeyEncryptionContext, "No encryption context");
        String string = ValidateUtils.checkNotNullAndNotEmpty(privateKeyEncryptionContext.getCipherName(), "No cipher name");
        ValidateUtils.checkNotNullAndNotEmpty(privateKeyEncryptionContext.getCipherType(), "No cipher type");
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(privateKeyEncryptionContext.getCipherMode(), "No cipher mode");
        Objects.requireNonNull(byArray, "No source data");
        Objects.requireNonNull(byArray2, "No encryption key");
        ValidateUtils.checkTrue(byArray2.length > 0, "Empty encryption key");
        byte[] byArray3 = Objects.requireNonNull(privateKeyEncryptionContext.getInitVector(), "No encryption init vector");
        ValidateUtils.checkTrue(byArray3.length > 0, "Empty encryption init vector");
        String string3 = string + "/" + string2 + "/NoPadding";
        int n3 = Cipher.getMaxAllowedKeyLength(string3);
        if (n2 > n3) {
            throw new InvalidKeySpecException("applyPrivateKeyCipher(" + string3 + ")[encrypt=" + bl2 + "] required key length (" + n2 + ") exceeds max. available: " + n3);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, string);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
        Cipher cipher = SecurityUtils.getCipher(string3);
        int n4 = cipher.getBlockSize();
        int n5 = byArray.length;
        cipher.init(bl2 ? 1 : 2, (Key)secretKeySpec, ivParameterSpec);
        if (n4 <= 0) {
            return cipher.doFinal(byArray);
        }
        int n6 = n5 % n4;
        if (n6 <= 0) {
            return cipher.doFinal(byArray);
        }
        int n7 = n5 - n6;
        byte[] byArray4 = new byte[n4];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5);
        try {
            Arrays.fill(byArray4, (byte)10);
            System.arraycopy(byArray, n7, byArray4, 0, n6);
            try {
                byte[] byArray5 = cipher.update(byArray, 0, n7);
                try {
                    byteArrayOutputStream.write(byArray5);
                }
                finally {
                    Arrays.fill(byArray5, (byte)0);
                }
                byArray5 = cipher.doFinal(byArray4);
                try {
                    byteArrayOutputStream.write(byArray5);
                }
                finally {
                    Arrays.fill(byArray5, (byte)0);
                }
            }
            finally {
                byteArrayOutputStream.close();
            }
        }
        finally {
            Arrays.fill(byArray4, (byte)0);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

