/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractKeyPairResourceParser
extends AbstractLoggingBean
implements KeyPairResourceParser {
    private final List beginners;
    private final List enders;
    private final List endingMarkers;

    protected AbstractKeyPairResourceParser(List list, List list2) {
        this.beginners = (List)ValidateUtils.checkNotNullAndNotEmpty(list, "No begin markers", new Object[0]);
        this.enders = (List)ValidateUtils.checkNotNullAndNotEmpty(list2, "No end markers", new Object[0]);
        ValidateUtils.checkTrue(list.size() == list2.size(), "Mismatched begin(%d)/end(%d) markers sizes", list.size(), list2.size());
        this.endingMarkers = new ArrayList(list2.size());
        list2.forEach(string -> this.endingMarkers.add(Collections.singletonList(string)));
    }

    public List getBeginners() {
        return this.beginners;
    }

    public List getEnders() {
        return this.enders;
    }

    public List getEndingMarkers() {
        return this.endingMarkers;
    }

    @Override
    public boolean canExtractKeyPairs(NamedResource namedResource, List list) {
        return KeyPairResourceParser.containsMarkerLine(list, this.getBeginners());
    }

    @Override
    public Collection loadKeyPairs(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider filePasswordProvider, List list) {
        List list2 = Collections.emptyList();
        List list3 = this.getBeginners();
        List list4 = this.getEndingMarkers();
        AbstractMap.SimpleImmutableEntry simpleImmutableEntry = KeyPairResourceParser.findMarkerLine(list, list3);
        while (simpleImmutableEntry != null) {
            int n2 = (Integer)simpleImmutableEntry.getKey();
            String string = (String)list.get(n2);
            int n3 = (Integer)simpleImmutableEntry.getValue();
            List list5 = (List)list4.get(n3);
            if ((simpleImmutableEntry = KeyPairResourceParser.findMarkerLine(list, ++n2, list5)) == null) {
                throw new StreamCorruptedException("Missing end marker (" + list5 + ") after line #" + n2);
            }
            int n4 = (Integer)simpleImmutableEntry.getKey();
            String string2 = (String)list.get(n4);
            Map.Entry entry = this.separateDataLinesFromHeaders(sessionContext, namedResource, string, string2, list.subList(n2, n4));
            Map map = (Map)entry.getKey();
            List list6 = (List)entry.getValue();
            Collection collection = this.extractKeyPairs(sessionContext, namedResource, string, string2, filePasswordProvider, list6 == null ? Collections.emptyList() : list6, map == null ? Collections.emptyMap() : map);
            if (GenericUtils.isNotEmpty(collection)) {
                if (GenericUtils.isEmpty(list2)) {
                    list2 = new LinkedList(collection);
                } else {
                    list2.addAll(collection);
                }
            }
            simpleImmutableEntry = KeyPairResourceParser.findMarkerLine(list, n4 + 1, list3);
        }
        return list2;
    }

    protected Map.Entry separateDataLinesFromHeaders(SessionContext sessionContext, NamedResource namedResource, String string, String string2, List list) {
        return new AbstractMap.SimpleImmutableEntry(Collections.emptyMap(), list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string, String string2, FilePasswordProvider filePasswordProvider, List list, Map map) {
        byte[] byArray = KeyPairResourceParser.extractDataBytes(list);
        try {
            Collection collection = this.extractKeyPairs(sessionContext, namedResource, string, string2, filePasswordProvider, byArray, map);
            return collection;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string, String string2, FilePasswordProvider filePasswordProvider, byte[] byArray, Map map) {
        if (this.log.isTraceEnabled()) {
            BufferUtils.dumpHex(this.getSimplifiedLogger(), Level.FINER, string, ':', 16, byArray);
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            Collection collection = this.extractKeyPairs(sessionContext, namedResource, string, string2, filePasswordProvider, byteArrayInputStream, map);
            return collection;
        }
    }

    public abstract Collection extractKeyPairs(SessionContext var1, NamedResource var2, String var3, String var4, FilePasswordProvider var5, InputStream var6, Map var7);
}

