/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.function.Predicate;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.config.keys.loader.AESPrivateKeyObfuscator$LazyKeyLengthsHolder;
import org.apache.sshd.common.config.keys.loader.AbstractPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;

public class AESPrivateKeyObfuscator
extends AbstractPrivateKeyObfuscator {
    public static final String CIPHER_NAME = "AES";
    public static final AESPrivateKeyObfuscator INSTANCE = new AESPrivateKeyObfuscator();

    public AESPrivateKeyObfuscator() {
        super(CIPHER_NAME);
    }

    @Override
    public List getSupportedKeySizes() {
        return AESPrivateKeyObfuscator.getAvailableKeyLengths();
    }

    @Override
    public byte[] applyPrivateKeyCipher(byte[] byArray, PrivateKeyEncryptionContext privateKeyEncryptionContext, boolean bl2) {
        int n2 = this.resolveKeyLength(privateKeyEncryptionContext);
        byte[] byArray2 = this.deriveEncryptionKey(privateKeyEncryptionContext, n2 / 8);
        return this.applyPrivateKeyCipher(byArray, privateKeyEncryptionContext, n2, byArray2, bl2);
    }

    @Override
    protected int resolveInitializationVectorLength(PrivateKeyEncryptionContext privateKeyEncryptionContext) {
        int n2 = this.resolveKeyLength(privateKeyEncryptionContext);
        CipherInformation cipherInformation = this.resolveCipherInformation(n2, privateKeyEncryptionContext.getCipherMode());
        if (cipherInformation == null) {
            throw new NoSuchAlgorithmException("No match found for " + privateKeyEncryptionContext);
        }
        return cipherInformation.getIVSize();
    }

    protected CipherInformation resolveCipherInformation(int n2, String string) {
        Predicate predicate = AESPrivateKeyObfuscator.createCipherSelector(n2, string);
        return BuiltinCiphers.VALUES.stream().filter(predicate).findFirst().orElse(null);
    }

    @Override
    protected int resolveKeyLength(PrivateKeyEncryptionContext privateKeyEncryptionContext) {
        String string = privateKeyEncryptionContext.getCipherType();
        try {
            int n2 = Integer.parseInt(string);
            List list = this.getSupportedKeySizes();
            for (Integer n3 : list) {
                if (n3 != n2) continue;
                return n2;
            }
            throw new InvalidKeySpecException("Unknown " + this.getCipherName() + " key length: " + string + " - supported: " + list);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeySpecException("Bad " + this.getCipherName() + " key length (" + string + "): " + numberFormatException.getMessage(), numberFormatException);
        }
    }

    public static List getAvailableKeyLengths() {
        return AESPrivateKeyObfuscator$LazyKeyLengthsHolder.access$000();
    }

    public static Predicate createCipherSelector(int n2, String string) {
        String string2 = "/" + string.toUpperCase() + "/";
        return cipherInformation -> CIPHER_NAME.equalsIgnoreCase(cipherInformation.getAlgorithm()) && n2 == cipherInformation.getKeySize() && cipherInformation.getTransformation().contains(string2);
    }
}

