/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.u2f.SkED25519PublicKey;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.security.eddsa.Ed25519PublicKeyDecoder;

public class SkED25519PublicKeyEntryDecoder
extends AbstractPublicKeyEntryDecoder {
    public static final String KEY_TYPE = "sk-ssh-ed25519@openssh.com";
    public static final int MAX_APP_NAME_LENGTH = 1024;
    public static final SkED25519PublicKeyEntryDecoder INSTANCE = new SkED25519PublicKeyEntryDecoder();
    private static final String NO_TOUCH_REQUIRED_HEADER = "no-touch-required";

    public SkED25519PublicKeyEntryDecoder() {
        super(SkED25519PublicKey.class, PrivateKey.class, Collections.singleton(KEY_TYPE));
    }

    @Override
    public SkED25519PublicKey decodePublicKey(SessionContext sessionContext, String string, InputStream inputStream, Map map) {
        if (!KEY_TYPE.equals(string)) {
            throw new InvalidKeySpecException("Invalid keyType: " + string);
        }
        boolean bl2 = this.parseBooleanHeader(map, NO_TOUCH_REQUIRED_HEADER, false);
        EdDSAPublicKey edDSAPublicKey = Ed25519PublicKeyDecoder.INSTANCE.decodePublicKey(sessionContext, "ssh-ed25519", inputStream, map);
        String string2 = KeyEntryResolver.decodeString(inputStream, 1024);
        return new SkED25519PublicKey(string2, bl2, edDSAPublicKey);
    }

    public SkED25519PublicKey clonePublicKey(SkED25519PublicKey skED25519PublicKey) {
        if (skED25519PublicKey == null) {
            return null;
        }
        return new SkED25519PublicKey(skED25519PublicKey.getAppName(), skED25519PublicKey.isNoTouchRequired(), skED25519PublicKey.getDelegatePublicKey());
    }

    public String encodePublicKey(OutputStream outputStream, SkED25519PublicKey skED25519PublicKey) {
        Objects.requireNonNull(skED25519PublicKey, "No public key provided");
        KeyEntryResolver.encodeString(outputStream, KEY_TYPE);
        byte[] byArray = Ed25519PublicKeyDecoder.getSeedValue(skED25519PublicKey.getDelegatePublicKey());
        KeyEntryResolver.writeRLEBytes(outputStream, byArray);
        KeyEntryResolver.encodeString(outputStream, skED25519PublicKey.getAppName());
        return KEY_TYPE;
    }

    @Override
    public PrivateKey clonePrivateKey(PrivateKey privateKey) {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }

    @Override
    public KeyPair generateKeyPair(int n2) {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }
}

