/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.impl.ECDSAPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.u2f.SkEcdsaPublicKey;
import org.apache.sshd.common.session.SessionContext;

public class SkECDSAPublicKeyEntryDecoder
extends AbstractPublicKeyEntryDecoder {
    public static final String KEY_TYPE = "sk-ecdsa-sha2-nistp256@openssh.com";
    public static final int MAX_APP_NAME_LENGTH = 1024;
    public static final SkECDSAPublicKeyEntryDecoder INSTANCE = new SkECDSAPublicKeyEntryDecoder();
    private static final String NO_TOUCH_REQUIRED_HEADER = "no-touch-required";

    public SkECDSAPublicKeyEntryDecoder() {
        super(SkEcdsaPublicKey.class, PrivateKey.class, Collections.singleton(KEY_TYPE));
    }

    @Override
    public SkEcdsaPublicKey decodePublicKey(SessionContext sessionContext, String string, InputStream inputStream, Map map) {
        if (!KEY_TYPE.equals(string)) {
            throw new InvalidKeySpecException("Invalid keyType: " + string);
        }
        boolean bl2 = this.parseBooleanHeader(map, NO_TOUCH_REQUIRED_HEADER, false);
        ECPublicKey eCPublicKey = ECDSAPublicKeyEntryDecoder.INSTANCE.decodePublicKey(ECCurves.nistp256, inputStream);
        String string2 = KeyEntryResolver.decodeString(inputStream, 1024);
        return new SkEcdsaPublicKey(string2, bl2, eCPublicKey);
    }

    public SkEcdsaPublicKey clonePublicKey(SkEcdsaPublicKey skEcdsaPublicKey) {
        if (skEcdsaPublicKey == null) {
            return null;
        }
        return new SkEcdsaPublicKey(skEcdsaPublicKey.getAppName(), skEcdsaPublicKey.isNoTouchRequired(), ECDSAPublicKeyEntryDecoder.INSTANCE.clonePublicKey(skEcdsaPublicKey.getDelegatePublicKey()));
    }

    public String encodePublicKey(OutputStream outputStream, SkEcdsaPublicKey skEcdsaPublicKey) {
        Objects.requireNonNull(skEcdsaPublicKey, "No public key provided");
        ECDSAPublicKeyEntryDecoder.encodePublicKey(outputStream, KEY_TYPE, ECCurves.nistp256, skEcdsaPublicKey.getDelegatePublicKey().getW());
        KeyEntryResolver.encodeString(outputStream, skEcdsaPublicKey.getAppName());
        return KEY_TYPE;
    }

    @Override
    public PrivateKey clonePrivateKey(PrivateKey privateKey) {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }

    @Override
    public KeyPair generateKeyPair(int n2) {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }
}

