/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.security.SecurityUtils;

public class RSAPublicKeyDecoder
extends AbstractPublicKeyEntryDecoder {
    public static final RSAPublicKeyDecoder INSTANCE = new RSAPublicKeyDecoder();

    public RSAPublicKeyDecoder() {
        super(RSAPublicKey.class, RSAPrivateKey.class, Collections.unmodifiableList(Arrays.asList("ssh-rsa", "rsa-sha2-256", "rsa-sha2-512")));
    }

    @Override
    public RSAPublicKey decodePublicKey(SessionContext sessionContext, String string, InputStream inputStream, Map map) {
        String string2 = KeyUtils.getCanonicalKeyType(string);
        if (!"ssh-rsa".equals(string2)) {
            throw new InvalidKeySpecException("Unexpected key type: " + string);
        }
        BigInteger bigInteger = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger2 = KeyEntryResolver.decodeBigInt(inputStream);
        return (RSAPublicKey)this.generatePublicKey(new RSAPublicKeySpec(bigInteger2, bigInteger));
    }

    public String encodePublicKey(OutputStream outputStream, RSAPublicKey rSAPublicKey) {
        Objects.requireNonNull(rSAPublicKey, "No public key provided");
        KeyEntryResolver.encodeString(outputStream, "ssh-rsa");
        KeyEntryResolver.encodeBigInt(outputStream, rSAPublicKey.getPublicExponent());
        KeyEntryResolver.encodeBigInt(outputStream, rSAPublicKey.getModulus());
        return "ssh-rsa";
    }

    public RSAPublicKey clonePublicKey(RSAPublicKey rSAPublicKey) {
        if (rSAPublicKey == null) {
            return null;
        }
        return (RSAPublicKey)this.generatePublicKey(new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent()));
    }

    public RSAPrivateKey clonePrivateKey(RSAPrivateKey rSAPrivateKey) {
        if (rSAPrivateKey == null) {
            return null;
        }
        if (!(rSAPrivateKey instanceof RSAPrivateCrtKey)) {
            throw new InvalidKeyException("Cannot clone a non-RSAPrivateCrtKey: " + rSAPrivateKey.getClass().getSimpleName());
        }
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
        return (RSAPrivateKey)this.generatePrivateKey(new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        return SecurityUtils.getKeyPairGenerator("RSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        return SecurityUtils.getKeyFactory("RSA");
    }
}

