/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.cipher.ECCurves$ECPointCompression;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class ECDSAPublicKeyEntryDecoder
extends AbstractPublicKeyEntryDecoder {
    public static final int MAX_ALLOWED_POINT_SIZE = Short.MAX_VALUE;
    public static final int MAX_CURVE_NAME_LENGTH = 1024;
    public static final ECDSAPublicKeyEntryDecoder INSTANCE = new ECDSAPublicKeyEntryDecoder();
    public static final byte ECPOINT_UNCOMPRESSED_FORM_INDICATOR = 4;
    public static final byte ECPOINT_COMPRESSED_VARIANT_2 = 2;
    public static final byte ECPOINT_COMPRESSED_VARIANT_3 = 2;

    public ECDSAPublicKeyEntryDecoder() {
        super(ECPublicKey.class, ECPrivateKey.class, ECCurves.KEY_TYPES);
    }

    @Override
    public ECPublicKey decodePublicKey(SessionContext sessionContext, String string, InputStream inputStream, Map map) {
        ECCurves eCCurves = ECCurves.fromKeyType(string);
        if (eCCurves == null) {
            throw new InvalidKeySpecException("Not an EC curve name: " + string);
        }
        return this.decodePublicKey(eCCurves, inputStream);
    }

    ECPublicKey decodePublicKey(ECCurves eCCurves, InputStream inputStream) {
        ECPoint eCPoint;
        String string;
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        String string2 = eCCurves.getName();
        if (!string2.equals(string = KeyEntryResolver.decodeString(inputStream, 1024))) {
            throw new InvalidKeySpecException("Mismatched key curve name (" + string2 + ") vs. encoded one (" + string + ")");
        }
        byte[] byArray = KeyEntryResolver.readRLEBytes(inputStream, Short.MAX_VALUE);
        try {
            eCPoint = ECCurves.octetStringToEcPoint(byArray);
            if (eCPoint == null) {
                throw new InvalidKeySpecException("No ECPoint generated for curve=" + string2 + " from octets=" + BufferUtils.toHex(':', byArray));
            }
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidKeySpecException("Failed (" + runtimeException.getClass().getSimpleName() + ") to generate ECPoint for curve=" + string2 + " from octets=" + BufferUtils.toHex(':', byArray) + ": " + runtimeException.getMessage());
        }
        ECParameterSpec eCParameterSpec = eCCurves.getParameters();
        return (ECPublicKey)this.generatePublicKey(new ECPublicKeySpec(eCPoint, eCParameterSpec));
    }

    public ECPublicKey clonePublicKey(ECPublicKey eCPublicKey) {
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        if (eCPublicKey == null) {
            return null;
        }
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        if (eCParameterSpec == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (ECPublicKey)this.generatePublicKey(new ECPublicKeySpec(eCPublicKey.getW(), eCParameterSpec));
    }

    public ECPrivateKey clonePrivateKey(ECPrivateKey eCPrivateKey) {
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        if (eCPrivateKey == null) {
            return null;
        }
        ECParameterSpec eCParameterSpec = eCPrivateKey.getParams();
        if (eCParameterSpec == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (ECPrivateKey)this.generatePrivateKey(new ECPrivateKeySpec(eCPrivateKey.getS(), eCParameterSpec));
    }

    public String encodePublicKey(OutputStream outputStream, ECPublicKey eCPublicKey) {
        Objects.requireNonNull(eCPublicKey, "No public key provided");
        ECParameterSpec eCParameterSpec = Objects.requireNonNull(eCPublicKey.getParams(), "No EC parameters available");
        ECCurves eCCurves = Objects.requireNonNull(ECCurves.fromCurveParameters(eCParameterSpec), "Cannot determine curve");
        String string = eCCurves.getKeyType();
        ECDSAPublicKeyEntryDecoder.encodePublicKey(outputStream, string, eCCurves, eCPublicKey.getW());
        return string;
    }

    static void encodePublicKey(OutputStream outputStream, String string, ECCurves eCCurves, ECPoint eCPoint) {
        String string2 = eCCurves.getName();
        KeyEntryResolver.encodeString(outputStream, string);
        KeyEntryResolver.encodeString(outputStream, string2);
        ECCurves$ECPointCompression.UNCOMPRESSED.writeECPoint(outputStream, string2, eCPoint);
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        if (SecurityUtils.isECCSupported()) {
            return SecurityUtils.getKeyFactory("EC");
        }
        throw new NoSuchProviderException("ECC not supported");
    }

    @Override
    public KeyPair generateKeyPair(int n2) {
        ECCurves eCCurves = ECCurves.fromCurveSize(n2);
        if (eCCurves == null) {
            throw new InvalidKeySpecException("Unknown curve for key size=" + n2);
        }
        KeyPairGenerator keyPairGenerator = this.getKeyPairGenerator();
        keyPairGenerator.initialize(eCCurves.getParameters());
        return keyPairGenerator.generateKeyPair();
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        if (SecurityUtils.isECCSupported()) {
            return SecurityUtils.getKeyPairGenerator("EC");
        }
        throw new NoSuchProviderException("ECC not supported");
    }
}

