/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.security.SecurityUtils;

public class DSSPublicKeyEntryDecoder
extends AbstractPublicKeyEntryDecoder {
    public static final DSSPublicKeyEntryDecoder INSTANCE = new DSSPublicKeyEntryDecoder();

    public DSSPublicKeyEntryDecoder() {
        super(DSAPublicKey.class, DSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-dss")));
    }

    @Override
    public DSAPublicKey decodePublicKey(SessionContext sessionContext, String string, InputStream inputStream, Map map) {
        if (!"ssh-dss".equals(string)) {
            throw new InvalidKeySpecException("Unexpected key type: " + string);
        }
        BigInteger bigInteger = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger2 = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger3 = KeyEntryResolver.decodeBigInt(inputStream);
        BigInteger bigInteger4 = KeyEntryResolver.decodeBigInt(inputStream);
        return (DSAPublicKey)this.generatePublicKey(new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3));
    }

    public String encodePublicKey(OutputStream outputStream, DSAPublicKey dSAPublicKey) {
        Objects.requireNonNull(dSAPublicKey, "No public key provided");
        DSAParams dSAParams = Objects.requireNonNull(dSAPublicKey.getParams(), "No DSA params available");
        KeyEntryResolver.encodeString(outputStream, "ssh-dss");
        KeyEntryResolver.encodeBigInt(outputStream, dSAParams.getP());
        KeyEntryResolver.encodeBigInt(outputStream, dSAParams.getQ());
        KeyEntryResolver.encodeBigInt(outputStream, dSAParams.getG());
        KeyEntryResolver.encodeBigInt(outputStream, dSAPublicKey.getY());
        return "ssh-dss";
    }

    public DSAPublicKey clonePublicKey(DSAPublicKey dSAPublicKey) {
        if (dSAPublicKey == null) {
            return null;
        }
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (dSAParams == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (DSAPublicKey)this.generatePublicKey(new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG()));
    }

    public DSAPrivateKey clonePrivateKey(DSAPrivateKey dSAPrivateKey) {
        if (dSAPrivateKey == null) {
            return null;
        }
        DSAParams dSAParams = dSAPrivateKey.getParams();
        if (dSAParams == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (DSAPrivateKey)this.generatePrivateKey(new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        return SecurityUtils.getKeyPairGenerator("DSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        return SecurityUtils.getKeyFactory("DSA");
    }
}

