/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.Objects;
import org.apache.sshd.common.config.keys.IdentityResourceLoader;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractIdentityResourceLoader
extends AbstractLoggingBean
implements IdentityResourceLoader {
    private final Class pubType;
    private final Class prvType;
    private final NavigableSet types;

    protected AbstractIdentityResourceLoader(Class clazz, Class clazz2, Collection collection) {
        this.pubType = Objects.requireNonNull(clazz, "No public key type specified");
        this.prvType = Objects.requireNonNull(clazz2, "No private key type specified");
        this.types = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, ValidateUtils.checkNotNullAndNotEmpty(collection, "No key type names provided", new Object[0])));
    }

    @Override
    public final Class getPublicKeyType() {
        return this.pubType;
    }

    @Override
    public final Class getPrivateKeyType() {
        return this.prvType;
    }

    @Override
    public NavigableSet getSupportedKeyTypes() {
        return this.types;
    }
}

