/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PublicKey;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.io.resource.URLResource;

public interface PublicKeyRawDataReader {
    default public PublicKey readPublicKey(SessionContext sessionContext, Path path, OpenOption ... openOptionArray) {
        return this.readPublicKey(sessionContext, path, StandardCharsets.UTF_8, openOptionArray);
    }

    default public PublicKey readPublicKey(SessionContext sessionContext, Path path, Charset charset, OpenOption ... openOptionArray) {
        return this.readPublicKey(sessionContext, new PathResource(path, openOptionArray), charset);
    }

    default public PublicKey readPublicKey(SessionContext sessionContext, URL uRL) {
        return this.readPublicKey(sessionContext, uRL, StandardCharsets.UTF_8);
    }

    default public PublicKey readPublicKey(SessionContext sessionContext, URL uRL, Charset charset) {
        return this.readPublicKey(sessionContext, new URLResource(uRL), charset);
    }

    default public PublicKey readPublicKey(SessionContext sessionContext, IoResource ioResource) {
        return this.readPublicKey(sessionContext, ioResource, StandardCharsets.UTF_8);
    }

    default public PublicKey readPublicKey(SessionContext sessionContext, IoResource ioResource, Charset charset) {
        try (InputStream inputStream = Objects.requireNonNull(ioResource, "No resource data").openInputStream();){
            PublicKey publicKey = this.readPublicKey(sessionContext, ioResource, inputStream, charset);
            return publicKey;
        }
    }

    default public PublicKey readPublicKey(SessionContext sessionContext, NamedResource namedResource, InputStream inputStream) {
        return this.readPublicKey(sessionContext, namedResource, inputStream, StandardCharsets.UTF_8);
    }

    default public PublicKey readPublicKey(SessionContext sessionContext, NamedResource namedResource, InputStream inputStream, Charset charset) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream, "No stream instance"), Objects.requireNonNull(charset, "No charset"));){
            PublicKey publicKey = this.readPublicKey(sessionContext, namedResource, inputStreamReader);
            return publicKey;
        }
    }

    default public PublicKey readPublicKey(SessionContext sessionContext, NamedResource namedResource, Reader reader) {
        try (BufferedReader bufferedReader = new BufferedReader(Objects.requireNonNull(reader, "No reader instance"), 8192);){
            PublicKey publicKey = this.readPublicKey(sessionContext, namedResource, bufferedReader);
            return publicKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public PublicKey readPublicKey(SessionContext sessionContext, NamedResource namedResource, BufferedReader bufferedReader) {
        List list = IoUtils.readAllLines(bufferedReader);
        try {
            PublicKey publicKey = this.readPublicKey(sessionContext, namedResource, list);
            return publicKey;
        }
        finally {
            list.clear();
        }
    }

    public PublicKey readPublicKey(SessionContext var1, NamedResource var2, List var3);
}

