/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.PublicKeyRawDataDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface PublicKeyEntryDecoder
extends KeyEntryResolver,
PublicKeyEntryResolver,
PublicKeyRawDataDecoder {
    @Override
    default public PublicKey resolve(SessionContext sessionContext, String string, byte[] byArray, Map map) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No key type provided");
        NavigableSet navigableSet = this.getSupportedKeyTypes();
        if (GenericUtils.size(navigableSet) > 0 && navigableSet.contains(string)) {
            return this.decodePublicKey(sessionContext, string, byArray, map);
        }
        throw new InvalidKeySpecException("resolve(" + string + ") not in listed supported types: " + navigableSet);
    }

    @Override
    default public PublicKey decodePublicKeyByType(SessionContext sessionContext, String string, InputStream inputStream, Map map) {
        String string2 = KeyEntryResolver.decodeString(inputStream, 256);
        if (GenericUtils.isEmpty(string2)) {
            throw new StreamCorruptedException("Missing key type string");
        }
        NavigableSet navigableSet = this.getSupportedKeyTypes();
        if (GenericUtils.isEmpty(navigableSet) || !navigableSet.contains(string2)) {
            throw new InvalidKeySpecException("Reported key type (" + string2 + ") not in supported list: " + navigableSet);
        }
        return this.decodePublicKey(sessionContext, string2, inputStream, map);
    }

    public String encodePublicKey(OutputStream var1, PublicKey var2);
}

