/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry$LazyDefaultKeysFolderHolder;
import org.apache.sshd.common.config.keys.PublicKeyEntryDataResolver;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.keyprovider.KeyTypeIndicator;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class PublicKeyEntry
implements Serializable,
KeyTypeIndicator {
    public static final char COMMENT_CHAR = '#';
    public static final String STD_KEYFILE_FOLDER_NAME = ".ssh";
    public static final String PUBKEY_FILE_SUFFIX = ".pub";
    private static final long serialVersionUID = -585506072687602760L;
    private static final NavigableMap KEY_DATA_RESOLVERS = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private String keyType;
    private byte[] keyData;
    private PublicKeyEntryDataResolver keyDataResolver = PublicKeyEntryDataResolver.DEFAULT;

    public PublicKeyEntry() {
    }

    public PublicKeyEntry(String string, byte ... byArray) {
        this.keyType = string;
        this.keyData = byArray;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String string) {
        this.keyType = string;
    }

    public byte[] getKeyData() {
        return this.keyData;
    }

    public void setKeyData(byte[] byArray) {
        this.keyData = byArray;
    }

    public PublicKeyEntryDataResolver getKeyDataResolver() {
        return this.keyDataResolver;
    }

    public void setKeyDataResolver(PublicKeyEntryDataResolver publicKeyEntryDataResolver) {
        this.keyDataResolver = publicKeyEntryDataResolver;
    }

    public PublicKeyEntryDataResolver resolvePublicKeyEntryDataResolver() {
        PublicKeyEntryDataResolver publicKeyEntryDataResolver = this.getKeyDataResolver();
        return publicKeyEntryDataResolver == null ? PublicKeyEntryDataResolver.DEFAULT : publicKeyEntryDataResolver;
    }

    public PublicKey resolvePublicKey(SessionContext sessionContext, Map map, PublicKeyEntryResolver publicKeyEntryResolver) {
        String string = this.getKeyType();
        PublicKeyEntryResolver publicKeyEntryResolver2 = KeyUtils.getPublicKeyEntryDecoder(string);
        if (publicKeyEntryResolver2 == null) {
            publicKeyEntryResolver2 = publicKeyEntryResolver;
        }
        if (publicKeyEntryResolver2 == null) {
            throw new InvalidKeySpecException("No decoder available for key type=" + string);
        }
        return publicKeyEntryResolver2.resolve(sessionContext, string, this.getKeyData(), map);
    }

    public PublicKey appendPublicKey(SessionContext sessionContext, Appendable appendable, PublicKeyEntryResolver publicKeyEntryResolver) {
        PublicKey publicKey = this.resolvePublicKey(sessionContext, Collections.emptyMap(), publicKeyEntryResolver);
        if (publicKey != null) {
            PublicKeyEntry.appendPublicKeyEntry(appendable, publicKey, this.resolvePublicKeyEntryDataResolver());
        }
        return publicKey;
    }

    public int hashCode() {
        return Objects.hashCode(this.getKeyType()) + Arrays.hashCode(this.getKeyData());
    }

    protected boolean isEquivalent(PublicKeyEntry publicKeyEntry) {
        if (this == publicKeyEntry) {
            return true;
        }
        return Objects.equals(this.getKeyType(), publicKeyEntry.getKeyType()) && Arrays.equals(this.getKeyData(), publicKeyEntry.getKeyData());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.isEquivalent((PublicKeyEntry)object);
    }

    public String toString() {
        PublicKeyEntryDataResolver publicKeyEntryDataResolver = this.resolvePublicKeyEntryDataResolver();
        String string = publicKeyEntryDataResolver.encodeEntryKeyData(this.getKeyData());
        return this.getKeyType() + " " + (GenericUtils.isEmpty(string) ? "<no-key>" : string);
    }

    public static List resolvePublicKeyEntries(SessionContext sessionContext, Collection collection, PublicKeyEntryResolver publicKeyEntryResolver) {
        int n2 = GenericUtils.size(collection);
        if (n2 <= 0) {
            return Collections.emptyList();
        }
        ArrayList<PublicKey> arrayList = new ArrayList<PublicKey>(n2);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PublicKeyEntry publicKeyEntry;
            Map map = (publicKeyEntry = (PublicKeyEntry)iterator.next()) instanceof AuthorizedKeyEntry ? ((AuthorizedKeyEntry)publicKeyEntry).getLoginOptions() : Collections.emptyMap();
            PublicKey publicKey = publicKeyEntry.resolvePublicKey(sessionContext, map, publicKeyEntryResolver);
            if (publicKey == null) continue;
            arrayList.add(publicKey);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerKeyDataEntryResolver(String string, PublicKeyEntryDataResolver publicKeyEntryDataResolver) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No key type provided");
        Objects.requireNonNull(publicKeyEntryDataResolver, "No resolver provided");
        NavigableMap navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            KEY_DATA_RESOLVERS.put(string, publicKeyEntryDataResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDataResolver getKeyDataEntryResolver(String string) {
        string = ValidateUtils.checkNotNullAndNotEmpty(string, "No key type provided");
        NavigableMap navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            return (PublicKeyEntryDataResolver)KEY_DATA_RESOLVERS.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDataResolver unregisterKeyDataEntryResolver(String string) {
        string = ValidateUtils.checkNotNullAndNotEmpty(string, "No key type provided");
        NavigableMap navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            return (PublicKeyEntryDataResolver)KEY_DATA_RESOLVERS.remove(string);
        }
    }

    public static PublicKeyEntryDataResolver resolveKeyDataEntryResolver(String string) {
        PublicKeyEntryDataResolver publicKeyEntryDataResolver = PublicKeyEntry.getKeyDataEntryResolver(string = ValidateUtils.checkNotNullAndNotEmpty(string, "No key type provided"));
        if (publicKeyEntryDataResolver != null) {
            return publicKeyEntryDataResolver;
        }
        return PublicKeyEntryDataResolver.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableMap getRegisteredKeyDataEntryResolvers() {
        TreeMap treeMap;
        NavigableMap navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            if (KEY_DATA_RESOLVERS.isEmpty()) {
                return Collections.emptyNavigableMap();
            }
            treeMap = new TreeMap(KEY_DATA_RESOLVERS.comparator());
            treeMap.putAll(KEY_DATA_RESOLVERS);
        }
        return treeMap;
    }

    public static PublicKeyEntry parsePublicKeyEntry(String string) {
        return PublicKeyEntry.parsePublicKeyEntry(string, (PublicKeyEntryDataResolver)null);
    }

    public static PublicKeyEntry parsePublicKeyEntry(String string, PublicKeyEntryDataResolver publicKeyEntryDataResolver) {
        String string2 = GenericUtils.replaceWhitespaceAndTrim(string);
        if (GenericUtils.isEmpty(string2)) {
            return null;
        }
        return PublicKeyEntry.parsePublicKeyEntry(new PublicKeyEntry(), string2, publicKeyEntryDataResolver);
    }

    public static PublicKeyEntry parsePublicKeyEntry(PublicKeyEntry publicKeyEntry, String string) {
        return PublicKeyEntry.parsePublicKeyEntry(publicKeyEntry, string, null);
    }

    public static PublicKeyEntry parsePublicKeyEntry(PublicKeyEntry publicKeyEntry, String string, PublicKeyEntryDataResolver publicKeyEntryDataResolver) {
        String string2;
        byte[] byArray;
        String string3 = GenericUtils.replaceWhitespaceAndTrim(string);
        if (GenericUtils.isEmpty(string3) || publicKeyEntry == null) {
            return publicKeyEntry;
        }
        int n2 = string3.indexOf(32);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Bad format (no key data delimiter): " + string3);
        }
        int n3 = string3.indexOf(32, n2 + 1);
        if (n3 <= n2) {
            n3 = string3.length();
        }
        String string4 = string3.substring(0, n2);
        if (publicKeyEntryDataResolver == null) {
            publicKeyEntryDataResolver = PublicKeyEntry.resolveKeyDataEntryResolver(string4);
        }
        if (NumberUtils.isEmpty(byArray = publicKeyEntryDataResolver.decodeEntryKeyData(string2 = string3.substring(n2 + 1, n3).trim()))) {
            throw new IllegalArgumentException("Bad format (no BASE64 key data): " + string3);
        }
        publicKeyEntry.setKeyType(string4);
        publicKeyEntry.setKeyDataResolver(publicKeyEntryDataResolver);
        publicKeyEntry.setKeyData(byArray);
        return publicKeyEntry;
    }

    public static String toString(PublicKey publicKey) {
        return PublicKeyEntry.toString(publicKey, null);
    }

    public static String toString(PublicKey publicKey, PublicKeyEntryDataResolver publicKeyEntryDataResolver) {
        try {
            return ((StringBuilder)PublicKeyEntry.appendPublicKeyEntry(new StringBuilder(127), publicKey, publicKeyEntryDataResolver)).toString();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed (" + iOException.getClass().getSimpleName() + ") to encode: " + iOException.getMessage(), iOException);
        }
    }

    public static Appendable appendPublicKeyEntry(Appendable appendable, PublicKey publicKey) {
        return PublicKeyEntry.appendPublicKeyEntry(appendable, publicKey, null);
    }

    public static Appendable appendPublicKeyEntry(Appendable appendable, PublicKey publicKey, PublicKeyEntryDataResolver publicKeyEntryDataResolver) {
        if (publicKey == null) {
            return appendable;
        }
        PublicKeyEntryDecoder publicKeyEntryDecoder = KeyUtils.getPublicKeyEntryDecoder(publicKey);
        if (publicKeyEntryDecoder == null) {
            throw new StreamCorruptedException("Cannot retrieve decoder for key=" + publicKey.getAlgorithm());
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(127);){
            String string = publicKeyEntryDecoder.encodePublicKey(byteArrayOutputStream, publicKey);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (publicKeyEntryDataResolver == null) {
                publicKeyEntryDataResolver = PublicKeyEntry.resolveKeyDataEntryResolver(string);
            }
            String string2 = publicKeyEntryDataResolver.encodeEntryKeyData(byArray);
            appendable.append(string).append(' ').append(string2);
        }
        return appendable;
    }

    public static Path getDefaultKeysFolderPath() {
        return PublicKeyEntry$LazyDefaultKeysFolderHolder.access$000();
    }
}

