/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.NavigableSet;
import java.util.Objects;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.PrivateKeyEntryResolver;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;

public interface PrivateKeyEntryDecoder
extends KeyEntryResolver,
PrivateKeyEntryResolver {
    @Override
    default public PrivateKey resolve(SessionContext sessionContext, String string, byte[] byArray) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No key type provided");
        NavigableSet navigableSet = this.getSupportedKeyTypes();
        if (GenericUtils.size(navigableSet) > 0 && navigableSet.contains(string)) {
            return this.decodePrivateKey(sessionContext, FilePasswordProvider.EMPTY, byArray);
        }
        throw new InvalidKeySpecException("resolve(" + string + ") not in listed supported types: " + navigableSet);
    }

    default public PrivateKey decodePrivateKey(SessionContext sessionContext, FilePasswordProvider filePasswordProvider, byte ... byArray) {
        return this.decodePrivateKey(sessionContext, filePasswordProvider, byArray, 0, NumberUtils.length(byArray));
    }

    default public PrivateKey decodePrivateKey(SessionContext sessionContext, FilePasswordProvider filePasswordProvider, byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            return null;
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, n3);){
            PrivateKey privateKey = this.decodePrivateKey(sessionContext, filePasswordProvider, byteArrayInputStream);
            return privateKey;
        }
    }

    default public PrivateKey decodePrivateKey(SessionContext sessionContext, FilePasswordProvider filePasswordProvider, InputStream inputStream) {
        String string = KeyEntryResolver.decodeString(inputStream, 256);
        if (GenericUtils.isEmpty(string)) {
            throw new StreamCorruptedException("Missing key type string");
        }
        NavigableSet navigableSet = this.getSupportedKeyTypes();
        if (GenericUtils.isEmpty(navigableSet) || !navigableSet.contains(string)) {
            throw new InvalidKeySpecException("Reported key type (" + string + ") not in supported list: " + navigableSet);
        }
        return this.decodePrivateKey(sessionContext, string, filePasswordProvider, inputStream);
    }

    public PrivateKey decodePrivateKey(SessionContext var1, String var2, FilePasswordProvider var3, InputStream var4);

    default public String encodePrivateKey(SecureByteArrayOutputStream secureByteArrayOutputStream, PrivateKey privateKey, PublicKey publicKey) {
        Objects.requireNonNull(privateKey, "No private key provided");
        return null;
    }

    default public boolean isPublicKeyRecoverySupported() {
        return false;
    }

    default public PublicKey recoverPublicKey(PrivateKey privateKey) {
        return null;
    }
}

