/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.security.PublicKey;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.OpenSshCertificate$Type;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class OpenSshCertificateImpl
implements OpenSshCertificate {
    private static final long serialVersionUID = -3592634724148744943L;
    private String keyType;
    private byte[] nonce;
    private PublicKey certificatePublicKey;
    private long serial;
    private int type;
    private String id;
    private Collection principals;
    private long validAfter = 0L;
    private long validBefore = -1L;
    private List criticalOptions;
    private List extensions;
    private String reserved;
    private PublicKey caPubKey;
    private byte[] message;
    private byte[] signature;

    @Override
    public String getRawKeyType() {
        return GenericUtils.isEmpty(this.keyType) ? null : this.keyType.split("@")[0].substring(0, this.keyType.indexOf("-cert"));
    }

    @Override
    public byte[] getNonce() {
        return this.nonce;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public PublicKey getCertPubKey() {
        return this.certificatePublicKey;
    }

    @Override
    public long getSerial() {
        return this.serial;
    }

    @Override
    public OpenSshCertificate$Type getType() {
        return OpenSshCertificate$Type.fromCode(this.type);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection getPrincipals() {
        return this.principals == null ? Collections.emptyList() : this.principals;
    }

    @Override
    public long getValidAfter() {
        return this.validAfter;
    }

    @Override
    public long getValidBefore() {
        return this.validBefore;
    }

    @Override
    public List getCriticalOptions() {
        return this.criticalOptions == null ? Collections.emptyList() : this.criticalOptions;
    }

    @Override
    public List getExtensions() {
        return this.extensions == null ? Collections.emptyList() : this.extensions;
    }

    @Override
    public String getReserved() {
        return this.reserved;
    }

    @Override
    public PublicKey getCaPubKey() {
        return this.caPubKey;
    }

    @Override
    public byte[] getMessage() {
        return this.message;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public byte[] getRawSignature() {
        if (this.signature == null) {
            return null;
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(this.signature);
        byteArrayBuffer.getString();
        return byteArrayBuffer.getBytes();
    }

    @Override
    public String getSignatureAlgorithm() {
        return NumberUtils.isEmpty(this.signature) ? null : new ByteArrayBuffer(this.signature).getString();
    }

    @Override
    public String getAlgorithm() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return GenericUtils.EMPTY_BYTE_ARRAY;
    }

    public void setKeyType(String string) {
        this.keyType = string;
    }

    public void setNonce(byte[] byArray) {
        this.nonce = byArray;
    }

    public void setCertPubKey(PublicKey publicKey) {
        this.certificatePublicKey = publicKey;
    }

    public void setSerial(long l2) {
        this.serial = l2;
    }

    public void setType(OpenSshCertificate$Type openSshCertificate$Type) {
        this.type = openSshCertificate$Type.getCode();
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setPrincipals(Collection collection) {
        this.principals = collection;
    }

    public void setValidAfter(long l2) {
        this.validAfter = l2;
    }

    public void setValidAfter(Instant instant) {
        if (instant == null) {
            this.setValidAfter(0L);
        } else if (Instant.EPOCH.compareTo(instant) <= 0) {
            this.setValidAfter(instant.getEpochSecond());
        } else {
            throw new IllegalArgumentException("Valid-after cannot be < epoch");
        }
    }

    public void setValidBefore(long l2) {
        this.validBefore = l2;
    }

    public void setValidBefore(Instant instant) {
        if (instant == null) {
            this.setValidBefore(-1L);
        } else if (Instant.EPOCH.compareTo(instant) <= 0) {
            this.setValidBefore(instant.getEpochSecond());
        } else {
            throw new IllegalArgumentException("Valid-before cannot be < epoch");
        }
    }

    public void setCriticalOptions(List list) {
        this.criticalOptions = list;
    }

    public void setExtensions(List list) {
        this.extensions = list;
    }

    public void setReserved(String string) {
        this.reserved = string;
    }

    public void setCaPubKey(PublicKey publicKey) {
        this.caPubKey = publicKey;
    }

    public void setMessage(byte[] byArray) {
        this.message = byArray;
    }

    public void setSignature(byte[] byArray) {
        this.signature = byArray;
    }

    private static String toDate(long l2) {
        if (l2 < 0L) {
            return "infinity";
        }
        Date date = new Date(TimeUnit.SECONDS.toMillis(l2));
        return date.toString();
    }

    public String toString() {
        return this.getKeyType() + "[id=" + this.getId() + ", serial=" + this.getSerial() + ", type=" + (Object)((Object)this.getType()) + ", validAfter=" + OpenSshCertificateImpl.toDate(this.getValidAfter()) + ", validBefore=" + OpenSshCertificateImpl.toDate(this.getValidBefore()) + "]";
    }
}

